/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.file;

import java.nio.file.FileSystem;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.ZipFileSystemAccessor;
import org.jetbrains.kotlin.konan.file.ZipFileSystemCacheableAccessor;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00009\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ/\u0010\r\u001a\u0002H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/konan/file/ZipFileSystemCacheableAccessor;", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemAccessor;", "cacheLimit", "", "(I)V", "initialCapacity", "loadFactor", "", "openedFileSystems", "org/jetbrains/kotlin/konan/file/ZipFileSystemCacheableAccessor$openedFileSystems$1", "Lorg/jetbrains/kotlin/konan/file/ZipFileSystemCacheableAccessor$openedFileSystems$1;", "reset", "", "withZipFileSystem", "T", "zipFile", "Lorg/jetbrains/kotlin/konan/file/File;", "action", "Lkotlin/Function1;", "Ljava/nio/file/FileSystem;", "(Lorg/jetbrains/kotlin/konan/file/File;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "kotlin-util-io"})
@SourceDebugExtension(value={"SMAP\nZipFileSystemAccessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipFileSystemAccessor.kt\norg/jetbrains/kotlin/konan/file/ZipFileSystemCacheableAccessor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,55:1\n381#2,7:56\n*S KotlinDebug\n*F\n+ 1 ZipFileSystemAccessor.kt\norg/jetbrains/kotlin/konan/file/ZipFileSystemCacheableAccessor\n*L\n35#1:56,7\n*E\n"})
public final class ZipFileSystemCacheableAccessor
implements ZipFileSystemAccessor {
    private final int cacheLimit;
    private final float loadFactor;
    private final int initialCapacity;
    @NotNull
    private final openedFileSystems.1 openedFileSystems;

    public ZipFileSystemCacheableAccessor(int cacheLimit) {
        this.cacheLimit = cacheLimit;
        this.loadFactor = 0.75f;
        int n = this.initialCapacity = (int)(1.0f + (float)this.cacheLimit / this.loadFactor);
        float f = this.loadFactor;
        this.openedFileSystems = new LinkedHashMap<File, FileSystem>(this, n, f){
            final /* synthetic */ ZipFileSystemCacheableAccessor this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2, true);
            }

            protected boolean removeEldestEntry(Map.Entry<File, ? extends FileSystem> eldest) {
                if (this.size() > ZipFileSystemCacheableAccessor.access$getCacheLimit$p(this.this$0)) {
                    Map.Entry<File, ? extends FileSystem> entry = eldest;
                    if (entry != null && (entry = entry.getValue()) != null) {
                        ((FileSystem)((Object)entry)).close();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public <T> T withZipFileSystem(@NotNull File zipFile, @NotNull Function1<? super FileSystem, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Map $this$getOrPut$iv = this.openedFileSystems;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(zipFile);
        if (value$iv == null) {
            boolean bl = false;
            FileSystem answer$iv = ZipUtilKt.zipFileSystem$default(zipFile, false, 1, null);
            $this$getOrPut$iv.put(zipFile, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        FileSystem fileSystem = (FileSystem)object;
        return (T)action.invoke((Object)fileSystem);
    }

    public final void reset() {
        Exception lastException = null;
        for (FileSystem fileSystem : this.openedFileSystems.values()) {
            try {
                fileSystem.close();
            }
            catch (Exception e) {
                lastException = e;
            }
        }
        this.openedFileSystems.clear();
        Iterator<FileSystem> iterator = lastException;
        if (iterator != null) {
            Iterator<FileSystem> it = iterator;
            boolean bl = false;
            throw it;
        }
    }

    public static final /* synthetic */ int access$getCacheLimit$p(ZipFileSystemCacheableAccessor $this) {
        return $this.cacheLimit;
    }
}

