/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.hocon.serializers;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigMemorySize;
import java.math.BigInteger;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.hocon.HoconDecoder;
import kotlinx.serialization.hocon.HoconEncoder;
import kotlinx.serialization.hocon.HoconExceptionsKt;
import kotlinx.serialization.hocon.serializers.ConfigMemorySizeSerializer;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0014\u0010\u0013\u001a\u00020\u0002*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lkotlinx/serialization/hocon/serializers/ConfigMemorySizeSerializer;", "Lkotlinx/serialization/KSerializer;", "Lcom/typesafe/config/ConfigMemorySize;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "memoryUnitFormats", "", "", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "decodeMemorySize", "Lcom/typesafe/config/Config;", "path", "kotlinx-serialization-hocon"})
public final class ConfigMemorySizeSerializer
implements KSerializer<ConfigMemorySize> {
    @NotNull
    public static final ConfigMemorySizeSerializer INSTANCE = new ConfigMemorySizeSerializer();
    @NotNull
    private static final List<String> memoryUnitFormats;
    @NotNull
    private static final SerialDescriptor descriptor;

    private ConfigMemorySizeSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    @NotNull
    public ConfigMemorySize deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        if (!(decoder instanceof HoconDecoder)) {
            HoconExceptionsKt.throwUnsupportedFormatException("ConfigMemorySizeSerializer");
            throw new KotlinNothingValueException();
        }
        return (ConfigMemorySize)((HoconDecoder)decoder).decodeConfigValue(deserialize.1.INSTANCE);
    }

    public void serialize(@NotNull Encoder encoder2, @NotNull ConfigMemorySize value) {
        int unitIndex;
        BigInteger bytes;
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (encoder2 instanceof HoconEncoder) {
            BigInteger andVal = BigInteger.valueOf(1023L);
            bytes = value.toBytesBigInteger();
            for (unitIndex = 0; Intrinsics.areEqual((Object)bytes.and(andVal), (Object)BigInteger.ZERO) && unitIndex < CollectionsKt.getLastIndex(memoryUnitFormats); ++unitIndex) {
                bytes = bytes.shiftRight(10);
            }
        } else {
            HoconExceptionsKt.throwUnsupportedFormatException("ConfigMemorySizeSerializer");
            throw new KotlinNothingValueException();
        }
        encoder2.encodeString(bytes + ' ' + memoryUnitFormats.get(unitIndex));
    }

    private final ConfigMemorySize decodeMemorySize(Config $this$decodeMemorySize, String path) {
        ConfigMemorySize configMemorySize;
        try {
            configMemorySize = $this$decodeMemorySize.getMemorySize(path);
            Intrinsics.checkNotNull((Object)configMemorySize);
        }
        catch (ConfigException e) {
            throw new SerializationException("Value at " + path + " cannot be read as ConfigMemorySize because it is not a valid HOCON Size value", (Throwable)e);
        }
        return configMemorySize;
    }

    public static final /* synthetic */ ConfigMemorySize access$decodeMemorySize(ConfigMemorySizeSerializer $this, Config $receiver, String path) {
        return $this.decodeMemorySize($receiver, path);
    }

    static {
        Object[] objectArray = new String[]{"byte", "KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "ZiB", "YiB"};
        memoryUnitFormats = CollectionsKt.listOf((Object[])objectArray);
        descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"hocon.com.typesafe.config.ConfigMemorySize", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));
    }
}

