/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.MissingFieldException;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.internal.AbstractPolymorphicSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonDecoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.internal.AbstractJsonLexer;
import kotlinx.serialization.json.internal.JsonDecoderForUnsignedTypes;
import kotlinx.serialization.json.internal.JsonElementMarker;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import kotlinx.serialization.json.internal.JsonNamesMapKt;
import kotlinx.serialization.json.internal.JsonTreeReader;
import kotlinx.serialization.json.internal.PolymorphicKt;
import kotlinx.serialization.json.internal.StreamingJsonEncoderKt;
import kotlinx.serialization.json.internal.WriteMode;
import kotlinx.serialization.json.internal.WriteModeKt;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0010\u0018\u00002\u00020\u00012\u00020\u0002:\u0001MB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0011H\u0002J\b\u0010!\u001a\u00020\u001fH\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\nH\u0016J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010/\u001a\u00020\u0011H\u0016J\b\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020\u0011H\u0002J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u0011H\u0002J\b\u00106\u001a\u00020\u001fH\u0016J\n\u00107\u001a\u0004\u0018\u000108H\u0016J\u0010\u00109\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0002J;\u0010:\u001a\u0002H;\"\u0004\b\u0000\u0010;2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u00112\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=2\b\u0010>\u001a\u0004\u0018\u0001H;H\u0016\u00a2\u0006\u0002\u0010?J!\u0010@\u001a\u0002H;\"\u0004\b\u0000\u0010;2\f\u0010<\u001a\b\u0012\u0004\u0012\u0002H;0=H\u0016\u00a2\u0006\u0002\u0010AJ\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u00020EH\u0002J\u0010\u0010G\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020EH\u0002J\u0010\u0010J\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0016\u0010K\u001a\u00020\u001f*\u0004\u0018\u00010\f2\u0006\u0010L\u001a\u00020EH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0007\u001a\u00020\b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006N"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder;", "Lkotlinx/serialization/json/JsonDecoder;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "json", "Lkotlinx/serialization/json/Json;", "mode", "Lkotlinx/serialization/json/internal/WriteMode;", "lexer", "Lkotlinx/serialization/json/internal/AbstractJsonLexer;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "discriminatorHolder", "Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "(Lkotlinx/serialization/json/Json;Lkotlinx/serialization/json/internal/WriteMode;Lkotlinx/serialization/json/internal/AbstractJsonLexer;Lkotlinx/serialization/descriptors/SerialDescriptor;Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;)V", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "currentIndex", "", "elementMarker", "Lkotlinx/serialization/json/internal/JsonElementMarker;", "getJson", "()Lkotlinx/serialization/json/Json;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "checkLeadingComma", "", "coerceInputValue", "", "index", "decodeBoolean", "decodeByte", "", "decodeChar", "", "decodeDouble", "", "decodeElementIndex", "decodeEnum", "enumDescriptor", "decodeFloat", "", "decodeInline", "Lkotlinx/serialization/encoding/Decoder;", "decodeInt", "decodeJsonElement", "Lkotlinx/serialization/json/JsonElement;", "decodeListIndex", "decodeLong", "", "decodeMapIndex", "decodeNotNullMark", "decodeNull", "", "decodeObjectIndex", "decodeSerializableElement", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "previousValue", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeSerializableValue", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "decodeShort", "", "decodeString", "", "decodeStringKey", "endStructure", "handleUnknown", "key", "skipLeftoverElements", "trySkip", "unknownKey", "DiscriminatorHolder", "kotlinx-serialization-json"})
@SourceDebugExtension(value={"SMAP\nStreamingJsonDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoder\n+ 2 AbstractJsonLexer.kt\nkotlinx/serialization/json/internal/AbstractJsonLexer\n+ 3 JsonNamesMap.kt\nkotlinx/serialization/json/internal/JsonNamesMapKt\n+ 4 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoderKt\n*L\n1#1,389:1\n463#2,3:390\n463#2,3:393\n105#3,11:396\n382#4,5:407\n382#4,5:412\n*S KotlinDebug\n*F\n+ 1 StreamingJsonDecoder.kt\nkotlinx/serialization/json/internal/StreamingJsonDecoder\n*L\n196#1:390,3\n197#1:393,3\n209#1:396,11\n311#1:407,5\n318#1:412,5\n*E\n"})
public class StreamingJsonDecoder
extends AbstractDecoder
implements JsonDecoder {
    @NotNull
    private final Json json;
    @NotNull
    private final WriteMode mode;
    @JvmField
    @NotNull
    public final AbstractJsonLexer lexer;
    @NotNull
    private final SerializersModule serializersModule;
    private int currentIndex;
    @Nullable
    private DiscriminatorHolder discriminatorHolder;
    @NotNull
    private final JsonConfiguration configuration;
    @Nullable
    private final JsonElementMarker elementMarker;

    public StreamingJsonDecoder(@NotNull Json json, @NotNull WriteMode mode, @NotNull AbstractJsonLexer lexer, @NotNull SerialDescriptor descriptor2, @Nullable DiscriminatorHolder discriminatorHolder) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        this.json = json;
        this.mode = mode;
        this.lexer = lexer;
        this.serializersModule = this.json.getSerializersModule();
        this.currentIndex = -1;
        this.discriminatorHolder = discriminatorHolder;
        this.configuration = this.json.getConfiguration();
        this.elementMarker = this.configuration.getExplicitNulls() ? null : new JsonElementMarker(descriptor2);
    }

    @Override
    @NotNull
    public final Json getJson() {
        return this.json;
    }

    private final boolean trySkip(DiscriminatorHolder $this$trySkip, String unknownKey) {
        if ($this$trySkip == null) {
            return false;
        }
        if (Intrinsics.areEqual((Object)$this$trySkip.discriminatorToSkip, (Object)unknownKey)) {
            $this$trySkip.discriminatorToSkip = null;
            return true;
        }
        return false;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    @Override
    @NotNull
    public JsonElement decodeJsonElement() {
        return new JsonTreeReader(this.json.getConfiguration(), this.lexer).read();
    }

    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        try {
            if (!(deserializer instanceof AbstractPolymorphicSerializer) || this.json.getConfiguration().getUseArrayPolymorphism()) {
                return (T)deserializer.deserialize((Decoder)this);
            }
            String discriminator = PolymorphicKt.classDiscriminator(deserializer.getDescriptor(), this.json);
            String type = this.lexer.consumeLeadingMatchingValue(discriminator, this.configuration.isLenient());
            DeserializationStrategy actualSerializer = null;
            if (type != null) {
                actualSerializer = ((AbstractPolymorphicSerializer)deserializer).findPolymorphicSerializerOrNull((CompositeDecoder)this, type);
            }
            if (actualSerializer == null) {
                return PolymorphicKt.decodeSerializableValuePolymorphic(this, deserializer);
            }
            this.discriminatorHolder = new DiscriminatorHolder(discriminator);
            Object result = actualSerializer.deserialize((Decoder)this);
            return (T)result;
        }
        catch (MissingFieldException e) {
            throw new MissingFieldException(e.getMissingFields(), e.getMessage() + " at path: " + this.lexer.path.getPath(), (Throwable)e);
        }
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        CompositeDecoder compositeDecoder;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        WriteMode newMode = WriteModeKt.switchMode(this.json, descriptor2);
        this.lexer.path.pushDescriptor(descriptor2);
        this.lexer.consumeNextToken(newMode.begin);
        this.checkLeadingComma();
        switch (WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                compositeDecoder = new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2, this.discriminatorHolder);
                break;
            }
            default: {
                compositeDecoder = this.mode == newMode && this.json.getConfiguration().getExplicitNulls() ? this : new StreamingJsonDecoder(this.json, newMode, this.lexer, descriptor2, this.discriminatorHolder);
            }
        }
        return compositeDecoder;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.json.getConfiguration().getIgnoreUnknownKeys() && descriptor2.getElementsCount() == 0) {
            this.skipLeftoverElements(descriptor2);
        }
        this.lexer.consumeNextToken(this.mode.end);
        this.lexer.path.popDescriptor();
    }

    private final void skipLeftoverElements(SerialDescriptor descriptor2) {
        while (this.decodeElementIndex(descriptor2) != -1) {
        }
    }

    public boolean decodeNotNullMark() {
        JsonElementMarker jsonElementMarker = this.elementMarker;
        return !(jsonElementMarker != null ? jsonElementMarker.isUnmarkedNull$kotlinx_serialization_json() : false) && this.lexer.tryConsumeNotNull();
    }

    @Nullable
    public Void decodeNull() {
        return null;
    }

    private final void checkLeadingComma() {
        if (this.lexer.peekNextToken() == 4) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
    }

    public <T> T decodeSerializableElement(@NotNull SerialDescriptor descriptor2, int index, @NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        boolean isMapKey;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        boolean bl = isMapKey = this.mode == WriteMode.MAP && (index & 1) == 0;
        if (isMapKey) {
            this.lexer.path.resetCurrentMapKey();
        }
        Object value = super.decodeSerializableElement(descriptor2, index, deserializer, previousValue);
        if (isMapKey) {
            this.lexer.path.updateCurrentMapKey(value);
        }
        return (T)value;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int index;
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.mode.ordinal()]) {
            case 4: {
                int n = this.decodeObjectIndex(descriptor2);
                break;
            }
            case 2: {
                int n = this.decodeMapIndex();
                break;
            }
            default: {
                int n = index = this.decodeListIndex();
            }
        }
        if (this.mode != WriteMode.MAP) {
            this.lexer.path.updateDescriptorIndex(index);
        }
        return index;
    }

    /*
     * WARNING - void declaration
     */
    private final int decodeMapIndex() {
        int n;
        boolean decodingKey;
        boolean hasComma = false;
        boolean bl = decodingKey = this.currentIndex % 2 != 0;
        if (decodingKey) {
            if (this.currentIndex != -1) {
                hasComma = this.lexer.tryConsumeComma();
            }
        } else {
            this.lexer.consumeNextToken(':');
        }
        if (this.lexer.canConsumeValue()) {
            if (decodingKey) {
                if (this.currentIndex == -1) {
                    void $this$iv;
                    AbstractJsonLexer abstractJsonLexer = this.lexer;
                    boolean condition$iv = !hasComma;
                    int position$iv = AbstractJsonLexer.access$getCurrentPosition$p((AbstractJsonLexer)$this$iv);
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!condition$iv) {
                        void var8_11 = $this$iv;
                        boolean bl2 = false;
                        AbstractJsonLexer.fail$default((AbstractJsonLexer)var8_11, "Unexpected trailing comma", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                } else {
                    AbstractJsonLexer $this$iv = this.lexer;
                    int position$iv = AbstractJsonLexer.access$getCurrentPosition$p($this$iv);
                    boolean $i$f$require$kotlinx_serialization_json = false;
                    if (!hasComma) {
                        AbstractJsonLexer abstractJsonLexer = $this$iv;
                        boolean bl3 = false;
                        AbstractJsonLexer.fail$default(abstractJsonLexer, "Expected comma after the key-value pair", position$iv, null, 4, null);
                        throw new KotlinNothingValueException();
                    }
                }
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected '}', but had ',' instead", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean coerceInputValue(SerialDescriptor descriptor2, int index) {
        void $this$tryCoerceValue$iv;
        void elementDescriptor$iv;
        Json json = this.json;
        SerialDescriptor serialDescriptor = descriptor2.getElementDescriptor(index);
        boolean $i$f$tryCoerceValue = false;
        if (!elementDescriptor$iv.isNullable()) {
            boolean bl = false;
            if (!this.lexer.tryConsumeNotNull()) {
                return true;
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
        }
        if (!Intrinsics.areEqual((Object)elementDescriptor$iv.getKind(), (Object)SerialKind.ENUM.INSTANCE)) return false;
        boolean bl = false;
        String string = this.lexer.peekString(this.configuration.isLenient());
        if (string == null) {
            return false;
        }
        String enumValue$iv = string;
        int enumIndex$iv = JsonNamesMapKt.getJsonNameIndex((SerialDescriptor)elementDescriptor$iv, (Json)$this$tryCoerceValue$iv, enumValue$iv);
        if (enumIndex$iv != -3) return false;
        boolean bl3 = false;
        this.lexer.consumeString();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final int decodeObjectIndex(SerialDescriptor descriptor2) {
        boolean hasComma = this.lexer.tryConsumeComma();
        while (this.lexer.canConsumeValue()) {
            boolean isUnknown;
            boolean bl;
            String key;
            block5: {
                hasComma = false;
                key = this.decodeStringKey();
                this.lexer.consumeNextToken(':');
                int index = JsonNamesMapKt.getJsonNameIndex(descriptor2, this.json, key);
                if (index != -3) {
                    if (this.configuration.getCoerceInputValues() && this.coerceInputValue(descriptor2, index)) {
                        hasComma = this.lexer.tryConsumeComma();
                        bl = false;
                        break block5;
                    } else {
                        JsonElementMarker jsonElementMarker = this.elementMarker;
                        if (jsonElementMarker == null) return index;
                        jsonElementMarker.mark$kotlinx_serialization_json(index);
                        return index;
                    }
                }
                bl = true;
            }
            if (!(isUnknown = bl)) continue;
            hasComma = this.handleUnknown(key);
        }
        if (hasComma) {
            AbstractJsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        JsonElementMarker jsonElementMarker = this.elementMarker;
        if (jsonElementMarker == null) return -1;
        int n = jsonElementMarker.nextUnmarkedIndex$kotlinx_serialization_json();
        return n;
    }

    private final boolean handleUnknown(String key) {
        if (this.configuration.getIgnoreUnknownKeys() || this.trySkip(this.discriminatorHolder, key)) {
            this.lexer.skipElement(this.configuration.isLenient());
        } else {
            this.lexer.failOnUnknownKey(key);
        }
        return this.lexer.tryConsumeComma();
    }

    private final int decodeListIndex() {
        int n;
        boolean hasComma = this.lexer.tryConsumeComma();
        if (this.lexer.canConsumeValue()) {
            if (this.currentIndex != -1 && !hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Expected end of the array or comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n = ++this.currentIndex;
        } else {
            if (hasComma) {
                AbstractJsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, null, 6, null);
                throw new KotlinNothingValueException();
            }
            n = -1;
        }
        return n;
    }

    public boolean decodeBoolean() {
        return this.configuration.isLenient() ? this.lexer.consumeBooleanLenient() : this.lexer.consumeBoolean();
    }

    public byte decodeByte() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((byte)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse byte for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (byte)value;
    }

    public short decodeShort() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((short)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse short for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (short)value;
    }

    public int decodeInt() {
        long value = this.lexer.consumeNumericLiteral();
        if (value != (long)((int)value)) {
            AbstractJsonLexer.fail$default(this.lexer, "Failed to parse int for input '" + value + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return (int)value;
    }

    public long decodeLong() {
        return this.lexer.consumeNumericLiteral();
    }

    /*
     * WARNING - void declaration
     */
    public float decodeFloat() {
        float f;
        float f2;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "float";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeFloat_u24lambda_u245 = input$iv;
            boolean bl = false;
            f2 = Float.parseFloat($this$decodeFloat_u24lambda_u245);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        float result = f2;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Float.isInfinite(f = result) && !Float.isNaN(f)) {
            return result;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, Float.valueOf(result));
        throw new KotlinNothingValueException();
    }

    /*
     * WARNING - void declaration
     */
    public double decodeDouble() {
        double d;
        double d2;
        void $this$parseString$iv;
        AbstractJsonLexer abstractJsonLexer = this.lexer;
        String expectedType$iv = "double";
        boolean $i$f$parseString = false;
        String input$iv = $this$parseString$iv.consumeStringLenient();
        try {
            String $this$decodeDouble_u24lambda_u246 = input$iv;
            boolean bl = false;
            d2 = Double.parseDouble($this$decodeDouble_u24lambda_u246);
        }
        catch (IllegalArgumentException e$iv) {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)$this$parseString$iv, "Failed to parse type '" + expectedType$iv + "' for input '" + input$iv + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        double result = d2;
        boolean specialFp = this.json.getConfiguration().getAllowSpecialFloatingPointValues();
        if (specialFp || !Double.isInfinite(d = result) && !Double.isNaN(d)) {
            return result;
        }
        JsonExceptionsKt.throwInvalidFloatingPointDecoded(this.lexer, result);
        throw new KotlinNothingValueException();
    }

    public char decodeChar() {
        String string = this.lexer.consumeStringLenient();
        if (string.length() != 1) {
            AbstractJsonLexer.fail$default(this.lexer, "Expected single char, but got '" + string + '\'', 0, null, 6, null);
            throw new KotlinNothingValueException();
        }
        return string.charAt(0);
    }

    private final String decodeStringKey() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeKeyString();
    }

    @NotNull
    public String decodeString() {
        return this.configuration.isLenient() ? this.lexer.consumeStringLenientNotNull() : this.lexer.consumeString();
    }

    @NotNull
    public Decoder decodeInline(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return StreamingJsonEncoderKt.isUnsignedNumber(descriptor2) ? (Decoder)new JsonDecoderForUnsignedTypes(this.lexer, this.json) : super.decodeInline(descriptor2);
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return JsonNamesMapKt.getJsonNameIndexOrThrow(enumDescriptor, this.json, this.decodeString(), " at path " + this.lexer.path.getPath());
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lkotlinx/serialization/json/internal/StreamingJsonDecoder$DiscriminatorHolder;", "", "discriminatorToSkip", "", "(Ljava/lang/String;)V", "kotlinx-serialization-json"})
    public static final class DiscriminatorHolder {
        @JvmField
        @Nullable
        public String discriminatorToSkip;

        public DiscriminatorHolder(@Nullable String discriminatorToSkip) {
            this.discriminatorToSkip = discriminatorToSkip;
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[WriteMode.values().length];
            try {
                nArray[WriteMode.LIST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.MAP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.POLY_OBJ.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WriteMode.OBJ.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

