/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.colorspace;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.colorspace.XYZ;
import org.jetbrains.letsPlot.commons.values.Color;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"cieE", "", "referenceX", "referenceY", "referenceZ", "rgbFromXyz", "Lorg/jetbrains/letsPlot/commons/values/Color;", "xyz", "Lorg/jetbrains/letsPlot/commons/colorspace/XYZ;", "xyzFromRgb", "rgb", "commons"})
public final class XYZKt {
    public static final double referenceX = 95.047;
    public static final double referenceY = 100.0;
    public static final double referenceZ = 108.883;
    public static final double cieE = 0.008856;

    @NotNull
    public static final Color rgbFromXyz(@NotNull XYZ xyz) {
        Intrinsics.checkNotNullParameter((Object)xyz, (String)"xyz");
        double x2 = xyz.getX() / 100.0;
        double y2 = xyz.getY() / 100.0;
        double z = xyz.getZ() / 100.0;
        double xyzR = x2 * 3.2406 + y2 * -1.5372 + z * -0.4986;
        double xyzG = x2 * -0.9689 + y2 * 1.8758 + z * 0.0415;
        double xyzB = x2 * 0.0557 + y2 * -0.204 + z * 1.057;
        double r = XYZKt.rgbFromXyz$transform(xyzR);
        double g = XYZKt.rgbFromXyz$transform(xyzG);
        double b = XYZKt.rgbFromXyz$transform(xyzB);
        return new Color(RangesKt.coerceIn((int)MathKt.roundToInt((double)(r * (double)255)), (int)0, (int)255), RangesKt.coerceIn((int)MathKt.roundToInt((double)(g * (double)255)), (int)0, (int)255), RangesKt.coerceIn((int)MathKt.roundToInt((double)(b * (double)255)), (int)0, (int)255), 0, 8, null);
    }

    @NotNull
    public static final XYZ xyzFromRgb(@NotNull Color rgb) {
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        double red = XYZKt.xyzFromRgb$transform$0((double)rgb.getRed() / 255.0);
        double green = XYZKt.xyzFromRgb$transform$0((double)rgb.getGreen() / 255.0);
        double blue = XYZKt.xyzFromRgb$transform$0((double)rgb.getBlue() / 255.0);
        return new XYZ((red * 0.4124 + green * 0.3576 + blue * 0.1805) * 100.0, (red * 0.2126 + green * 0.7152 + blue * 0.0722) * 100.0, (red * 0.0193 + green * 0.1192 + blue * 0.9505) * 100.0);
    }

    private static final double rgbFromXyz$transform(double v) {
        return v > 0.0031308 ? 1.055 * Math.pow(v, 0.4166666666666667) - 0.055 : 12.92 * v;
    }

    private static final double xyzFromRgb$transform$0(double v) {
        return v > 0.04045 ? Math.pow((v + 0.055) / 1.055, 2.4) : v / 12.92;
    }
}

