/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.core.plot.base.ContinuousTransform;
import org.jetbrains.letsPlot.core.plot.base.Scale;
import org.jetbrains.letsPlot.core.plot.base.scale.AbstractScale;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0018B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u000f\b\u0012\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0015\u001a\u00020\u000eH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale;", "", "name", "", "continuousOutput", "", "(Ljava/lang/String;Z)V", "b", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale$MyBuilder;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale$MyBuilder;)V", "continuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "customBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "isContinuous", "()Z", "isContinuousDomain", "transform", "getTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "getBreaksGenerator", "with", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "MyBuilder", "plot-base"})
public final class ContinuousScale
extends AbstractScale<Double> {
    @NotNull
    private final ContinuousTransform continuousTransform;
    @Nullable
    private final BreaksGenerator customBreaksGenerator;
    private final boolean isContinuous;
    private final boolean isContinuousDomain;

    @Override
    public boolean isContinuous() {
        return this.isContinuous;
    }

    @Override
    public boolean isContinuousDomain() {
        return this.isContinuousDomain;
    }

    @Override
    @NotNull
    public ContinuousTransform getTransform() {
        return this.continuousTransform;
    }

    public ContinuousScale(@NotNull String name, boolean continuousOutput) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, null, 2, null);
        this.isContinuousDomain = true;
        this.isContinuous = continuousOutput;
        this.continuousTransform = Transforms.INSTANCE.getIDENTITY();
        this.customBreaksGenerator = null;
        this.setMultiplicativeExpand(0.05);
        this.setAdditiveExpand(0.0);
    }

    private ContinuousScale(MyBuilder b2) {
        super(b2);
        this.isContinuousDomain = true;
        this.continuousTransform = b2.getMyContinuousTransform();
        this.customBreaksGenerator = b2.getMyCustomBreaksGenerator();
        this.isContinuous = b2.getMyContinuousOutput();
    }

    @Override
    @NotNull
    public BreaksGenerator getBreaksGenerator() {
        return this.customBreaksGenerator != null ? (BreaksGenerator)new Transforms.BreaksGeneratorForTransformedDomain(this.continuousTransform, this.customBreaksGenerator) : Transforms.INSTANCE.createBreaksGeneratorForTransformedDomain(this.continuousTransform, this.getLabelFormatter());
    }

    @Override
    @NotNull
    public Scale.Builder with() {
        return new MyBuilder(this);
    }

    public /* synthetic */ ContinuousScale(MyBuilder b2, DefaultConstructorMarker $constructor_marker) {
        this(b2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale$MyBuilder;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/AbstractScale$AbstractBuilder;", "", "scale", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale;", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/ContinuousScale;)V", "myContinuousOutput", "", "getMyContinuousOutput", "()Z", "myContinuousTransform", "Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "getMyContinuousTransform", "()Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;", "setMyContinuousTransform", "(Lorg/jetbrains/letsPlot/core/plot/base/ContinuousTransform;)V", "myCustomBreaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "getMyCustomBreaksGenerator", "()Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "setMyCustomBreaksGenerator", "(Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;)V", "breaksGenerator", "Lorg/jetbrains/letsPlot/core/plot/base/Scale$Builder;", "v", "build", "Lorg/jetbrains/letsPlot/core/plot/base/Scale;", "continuousTransform", "plot-base"})
    private static final class MyBuilder
    extends AbstractScale.AbstractBuilder<Double> {
        @NotNull
        private ContinuousTransform myContinuousTransform;
        @Nullable
        private BreaksGenerator myCustomBreaksGenerator;
        private final boolean myContinuousOutput;

        public MyBuilder(@NotNull ContinuousScale scale) {
            Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
            super(scale);
            this.myContinuousTransform = scale.continuousTransform;
            this.myCustomBreaksGenerator = scale.customBreaksGenerator;
            this.myContinuousOutput = scale.isContinuous();
        }

        @NotNull
        public final ContinuousTransform getMyContinuousTransform() {
            return this.myContinuousTransform;
        }

        public final void setMyContinuousTransform(@NotNull ContinuousTransform continuousTransform) {
            Intrinsics.checkNotNullParameter((Object)continuousTransform, (String)"<set-?>");
            this.myContinuousTransform = continuousTransform;
        }

        @Nullable
        public final BreaksGenerator getMyCustomBreaksGenerator() {
            return this.myCustomBreaksGenerator;
        }

        public final void setMyCustomBreaksGenerator(@Nullable BreaksGenerator breaksGenerator) {
            this.myCustomBreaksGenerator = breaksGenerator;
        }

        public final boolean getMyContinuousOutput() {
            return this.myContinuousOutput;
        }

        @Override
        @NotNull
        public Scale.Builder continuousTransform(@NotNull ContinuousTransform v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myContinuousTransform = v;
            return this;
        }

        @Override
        @NotNull
        public Scale.Builder breaksGenerator(@NotNull BreaksGenerator v) {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            this.myCustomBreaksGenerator = v;
            return this;
        }

        @Override
        @NotNull
        public Scale build() {
            return new ContinuousScale(this, null);
        }
    }
}

