/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.stat.regression;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.core.plot.base.stat.math3.TDistribution;
import org.jetbrains.letsPlot.core.plot.base.stat.regression.EvalResult;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010BC\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionEvaluator;", "", "n", "", "meanX", "", "sumXX", "model", "Lkotlin/Function1;", "standardErrorOfEstimate", "tCritical", "(IDDLkotlin/jvm/functions/Function1;DD)V", "evalX", "Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/EvalResult;", "x", "value", "Companion", "plot-base"})
public abstract class RegressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int n;
    private final double meanX;
    private final double sumXX;
    @NotNull
    private final Function1<Double, Double> model;
    private final double standardErrorOfEstimate;
    private final double tCritical;

    protected RegressionEvaluator(int n, double meanX, double sumXX, @NotNull Function1<? super Double, Double> model2, double standardErrorOfEstimate, double tCritical) {
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        this.n = n;
        this.meanX = meanX;
        this.sumXX = sumXX;
        this.model = model2;
        this.standardErrorOfEstimate = standardErrorOfEstimate;
        this.tCritical = tCritical;
    }

    public final double value(double x) {
        return ((Number)this.model.invoke((Object)x)).doubleValue();
    }

    @NotNull
    public final EvalResult evalX(double x) {
        RegressionEvaluator $this$evalX_u24lambda_u240 = this;
        boolean bl = false;
        double dxSquare = Math.pow(x - $this$evalX_u24lambda_u240.meanX, 2);
        double se = $this$evalX_u24lambda_u240.standardErrorOfEstimate * Math.sqrt(1.0 / (double)$this$evalX_u24lambda_u240.n + dxSquare / $this$evalX_u24lambda_u240.sumXX);
        double halfConfidenceInterval = this.tCritical * se;
        double yHat = this.value(x);
        return new EvalResult(yHat, yHat - halfConfidenceInterval, yHat + halfConfidenceInterval, se);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\t2\u0006\u0010\n\u001a\u00020\u0004J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J.\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00102\u000e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00102\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionEvaluator$Companion;", "", "()V", "calcStandardErrorOfEstimate", "", "xVals", "", "yVals", "model", "Lkotlin/Function1;", "degreesOfFreedom", "calcTCritical", "confidenceLevel", "check", "", "xs", "", "ys", "plot-base"})
    @SourceDebugExtension(value={"SMAP\nRegressionEvaluator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RegressionEvaluator.kt\norg/jetbrains/letsPlot/core/plot/base/stat/regression/RegressionEvaluator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,78:1\n1#2:79\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void check(@NotNull List<Double> xs, @NotNull List<Double> ys, double confidenceLevel) {
            Intrinsics.checkNotNullParameter(xs, (String)"xs");
            Intrinsics.checkNotNullParameter(ys, (String)"ys");
            if (!(0.01 <= confidenceLevel ? confidenceLevel <= 0.99 : false)) {
                boolean $i$a$-require-RegressionEvaluator$Companion$check$32 = false;
                String $i$a$-require-RegressionEvaluator$Companion$check$32 = "Confidence level is out of range [0.01-0.99]. CL:" + confidenceLevel;
                throw new IllegalArgumentException($i$a$-require-RegressionEvaluator$Companion$check$32.toString());
            }
            if (!(xs.size() == ys.size())) {
                boolean bl = false;
                String string = "X/Y must have same size. X:" + xs.size() + " Y:" + ys.size();
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final double calcStandardErrorOfEstimate(@NotNull double[] xVals, @NotNull double[] yVals, @NotNull Function1<? super Double, Double> model2, double degreesOfFreedom) {
            Intrinsics.checkNotNullParameter((Object)xVals, (String)"xVals");
            Intrinsics.checkNotNullParameter((Object)yVals, (String)"yVals");
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            Iterable iterable = ArraysKt.zip((double[])xVals, (double[])yVals);
            double d = 0.0;
            for (Object t : iterable) {
                Pair pair = (Pair)t;
                double d2 = d;
                boolean bl = false;
                double x = ((Number)pair.component1()).doubleValue();
                double y = ((Number)pair.component2()).doubleValue();
                double d3 = Math.pow(y - ((Number)model2.invoke((Object)x)).doubleValue(), 2);
                d = d2 + d3;
            }
            double sse = d;
            return Math.sqrt(sse / degreesOfFreedom);
        }

        public final double calcTCritical(double degreesOfFreedom, double confidenceLevel) {
            double d;
            if (degreesOfFreedom > 0.0) {
                double alpha = 1.0 - confidenceLevel;
                d = new TDistribution(degreesOfFreedom, 0.0, 2, null).inverseCumulativeProbability(1.0 - alpha / 2.0);
            } else {
                d = Double.NaN;
            }
            return d;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

