/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.ScaleMapper;
import org.jetbrains.letsPlot.core.plot.base.render.svg.MultilineLabel;
import org.jetbrains.letsPlot.core.plot.base.render.svg.Text;
import org.jetbrains.letsPlot.core.plot.builder.guide.ColorBarComponentLayout;
import org.jetbrains.letsPlot.core.plot.builder.guide.ColorBarComponentSpec;
import org.jetbrains.letsPlot.core.plot.builder.guide.LegendBox;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLabelSpecFactory;
import org.jetbrains.letsPlot.core.plot.builder.layout.PlotLayoutUtil;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgGElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgLineElement;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgRectElement;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004JN\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponent;", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/LegendBox;", "spec", "Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentSpec;", "(Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentSpec;)V", "getSpec", "()Lorg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponentSpec;", "addColorBar", "", "g", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgGElement;", "domain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "mapper", "Lorg/jetbrains/letsPlot/core/plot/base/ScaleMapper;", "Lorg/jetbrains/letsPlot/commons/values/Color;", "numBins", "", "barBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "barLengthExpand", "", "horizontal", "", "reverse", "addTickMark", "p0", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "p1", "appendGuideContent", "contentRoot", "Lorg/jetbrains/letsPlot/datamodel/svg/dom/SvgNode;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nColorBarComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColorBarComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponent\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,174:1\n1549#2:175\n1620#2,3:176\n*S KotlinDebug\n*F\n+ 1 ColorBarComponent.kt\norg/jetbrains/letsPlot/core/plot/builder/guide/ColorBarComponent\n*L\n127#1:175\n127#1:176,3\n*E\n"})
public final class ColorBarComponent
extends LegendBox {
    @NotNull
    private final ColorBarComponentSpec spec;

    public ColorBarComponent(@NotNull ColorBarComponentSpec spec) {
        Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
        this.spec = spec;
    }

    @Override
    @NotNull
    public ColorBarComponentSpec getSpec() {
        return this.spec;
    }

    @Override
    @NotNull
    protected DoubleVector appendGuideContent(@NotNull SvgNode contentRoot) {
        Intrinsics.checkNotNullParameter((Object)contentRoot, (String)"contentRoot");
        ColorBarComponentLayout layout = this.getSpec().getLayout();
        SvgGElement guideBarGroup = new SvgGElement();
        DoubleRectangle barBounds = layout.getBarBounds();
        boolean horizontal = layout.isHorizontal();
        this.addColorBar(guideBarGroup, this.getSpec().getDomain(), this.getSpec().getScaleMapper(), this.getSpec().getBinCount(), barBounds, layout.getBarLengthExpand(), horizontal, this.getSpec().getReverse());
        double barThickness = horizontal ? barBounds.getHeight() : barBounds.getWidth();
        double tickLength = barThickness / (double)5;
        Iterator<ColorBarComponentLayout.BreakInfo> breakInfos = layout.getBreakInfos$plot_builder().iterator();
        for (String brLabel : this.getSpec().getBreaks().getLabels()) {
            double d;
            ColorBarComponentLayout.BreakInfo brInfo = breakInfos.next();
            double tickLocation = brInfo.getTickLocation();
            ArrayList<DoubleVector> tickMarkPoints = new ArrayList<DoubleVector>();
            if (horizontal) {
                double tickX = barBounds.getLeft() + tickLocation;
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getTop()));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getTop() + tickLength));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getBottom() - tickLength));
                tickMarkPoints.add(new DoubleVector(tickX, barBounds.getBottom()));
            } else {
                double tickY = barBounds.getTop() + tickLocation;
                tickMarkPoints.add(new DoubleVector(barBounds.getLeft(), tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getLeft() + tickLength, tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getRight() - tickLength, tickY));
                tickMarkPoints.add(new DoubleVector(barBounds.getRight(), tickY));
            }
            Object e = tickMarkPoints.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            DoubleVector doubleVector = (DoubleVector)e;
            Object e2 = tickMarkPoints.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"get(...)");
            this.addTickMark(guideBarGroup, doubleVector, (DoubleVector)e2);
            Object e3 = tickMarkPoints.get(2);
            Intrinsics.checkNotNullExpressionValue(e3, (String)"get(...)");
            DoubleVector doubleVector2 = (DoubleVector)e3;
            Object e4 = tickMarkPoints.get(3);
            Intrinsics.checkNotNullExpressionValue(e4, (String)"get(...)");
            this.addTickMark(guideBarGroup, doubleVector2, (DoubleVector)e4);
            double lineHeight = PlotLabelSpecFactory.INSTANCE.legendItem(this.getTheme()).height();
            MultilineLabel label = new MultilineLabel(brLabel);
            label.addClassName("legend-item");
            label.setHorizontalAnchor(brInfo.getLabelHorizontalAnchor());
            label.setLineHeight(lineHeight);
            switch (WhenMappings.$EnumSwitchMapping$0[brInfo.getLabelVerticalAnchor().ordinal()]) {
                case 1: {
                    d = lineHeight * 0.7;
                    break;
                }
                case 2: {
                    d = -ColorBarComponent.appendGuideContent$labelSize(brLabel, this).getY() + lineHeight;
                    break;
                }
                case 3: {
                    d = -ColorBarComponent.appendGuideContent$labelSize(brLabel, this).getY() / (double)2 + lineHeight * 0.85;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double yOffset2 = d;
            label.moveTo(brInfo.getLabelLocation().getX(), brInfo.getLabelLocation().getY() + barBounds.getTop() + yOffset2);
            guideBarGroup.children().add((Object)label.getRootGroup());
        }
        if (this.getDebug()) {
            DoubleRectangle graphBounds = new DoubleRectangle(DoubleVector.Companion.getZERO(), layout.getGraphSize());
            guideBarGroup.children().add((Object)LegendBox.Companion.createTransparentRect(graphBounds, Color.Companion.getDARK_BLUE(), 1.0));
        }
        contentRoot.children().add((Object)guideBarGroup);
        return layout.getSize();
    }

    /*
     * WARNING - void declaration
     */
    private final void addColorBar(SvgGElement g, DoubleSpan domain, ScaleMapper<Color> mapper, int numBins, DoubleRectangle barBounds, double barLengthExpand, boolean horizontal, boolean reverse) {
        void $this$mapTo$iv$iv;
        double domainSpan = domain.getLength();
        int stepCount = Math.max(2, numBins);
        double step = domainSpan / (double)stepCount;
        double v = domain.getLowerEnd() + step / (double)2;
        ArrayList<Double> domainValues = new ArrayList<Double>();
        for (int i = 0; i < stepCount; ++i) {
            domainValues.add(v + step * (double)i);
        }
        if (reverse) {
            CollectionsKt.reverse((List)domainValues);
        }
        Iterable $this$map$iv = domainValues;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Color)mapper.invoke(Double.valueOf((double)it)));
        }
        List colors = (List)destination$iv$iv;
        double barLength = horizontal ? barBounds.getWidth() : barBounds.getHeight();
        double effectiveBarLength = barLength - barLengthExpand * (double)2;
        double segmentStep = effectiveBarLength / (double)stepCount;
        double segmentLeft = barBounds.getLeft();
        double segmentRight = barBounds.getRight();
        double segmentBottom = barBounds.getBottom();
        double segmentTop = barBounds.getTop();
        Iterator iterator = colors.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int i = n++;
            Color color = (Color)iterator.next();
            SvgRectElement r = new SvgRectElement(segmentLeft, segmentTop, segmentRight - segmentLeft, segmentBottom - segmentTop);
            r.strokeWidth().set((Object)0.0);
            r.fillColor().set((Object)color);
            g.children().add((Object)r);
            if (horizontal) {
                segmentLeft += segmentStep;
            } else {
                segmentTop += segmentStep;
            }
            if (i != 0) continue;
            if (horizontal) {
                segmentLeft += barLengthExpand;
                continue;
            }
            segmentTop += barLengthExpand;
        }
    }

    private final void addTickMark(SvgGElement g, DoubleVector p0, DoubleVector p1) {
        SvgLineElement line2 = new SvgLineElement(p0.getX(), p0.getY(), p1.getX(), p1.getY());
        line2.strokeWidth().set((Object)1.0);
        line2.strokeColor().set((Object)this.getTheme().backgroundFill());
        g.children().add((Object)line2);
    }

    private static final DoubleVector appendGuideContent$labelSize(String brLabel, ColorBarComponent this$0) {
        return PlotLayoutUtil.INSTANCE.textDimensions$plot_builder(brLabel, PlotLabelSpecFactory.INSTANCE.legendItem(this$0.getTheme()));
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Text.VerticalAnchor.values().length];
            try {
                nArray[Text.VerticalAnchor.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Text.VerticalAnchor.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

