/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.binding.classes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.bcel.classfile.Utility;
import org.jibx.binding.classes.ClassFile;
import org.jibx.binding.classes.ClassItem;
import org.jibx.binding.model.ClassWrapper;
import org.jibx.runtime.JiBXException;
import org.jibx.util.IClass;
import org.jibx.util.IClassLocator;

public class ClassCache {
    private static ClassCache s_instance;
    private static HashSet s_preserveClasses;
    private String[] m_paths;
    private File[] m_roots;
    private HashMap m_classMap;

    private ClassCache(String[] paths) {
        int i;
        ArrayList<String> keepers = new ArrayList<String>();
        for (i = 0; i < paths.length; ++i) {
            File file = new File(paths[i]);
            if (!file.isDirectory() || !file.canWrite()) continue;
            keepers.add(paths[i]);
        }
        this.m_paths = new String[keepers.size()];
        this.m_roots = new File[keepers.size()];
        for (i = 0; i < keepers.size(); ++i) {
            String path = (String)keepers.get(i);
            int length = path.length();
            if (length > 0) {
                if (File.separatorChar != '/') {
                    path = path.replace('/', File.separatorChar);
                }
                if (path.charAt(length - 1) != File.separatorChar) {
                    path = path + File.separator;
                }
            }
            this.m_paths[i] = path;
            this.m_roots[i] = new File(path);
        }
        this.m_classMap = new HashMap();
    }

    private ClassFile getClassFileImpl(String name) throws JiBXException {
        Object match = this.m_classMap.get(name);
        if (match != null) {
            return (ClassFile)match;
        }
        if (ClassItem.isPrimitive(name) || name.endsWith("[]")) {
            ClassFile cf = new ClassFile(name, Utility.getSignature((String)name));
            this.m_classMap.put(name, cf);
            return cf;
        }
        try {
            ClassFile cf = null;
            String path = name.replace('.', File.separatorChar) + ".class";
            for (int i = 0; i < this.m_paths.length; ++i) {
                File file = new File(this.m_paths[i], path);
                if (!file.exists()) continue;
                cf = new ClassFile(name, this.m_roots[i], file);
                break;
            }
            if (cf == null) {
                cf = ClassFile.getClassFile(name);
            }
            if (cf != null) {
                String sname = cf.getSuperName();
                if (!name.equals(sname) && sname != null) {
                    ClassFile sf = this.getClassFileImpl(sname);
                    if (sf == null) {
                        throw new JiBXException("Superclass " + sname + " of class " + name + " not found");
                    }
                    cf.setSuperFile(sf);
                }
                this.m_classMap.put(name, cf);
            }
            return cf;
        }
        catch (IOException ex) {
            throw new JiBXException("Error loading class " + name);
        }
    }

    public static void addPreserveClass(String name) {
        s_preserveClasses.add(name);
        ClassFile cf = (ClassFile)ClassCache.s_instance.m_classMap.get(name);
        if (cf != null) {
            cf.setUnmodifiable();
        }
    }

    public static boolean isPreserveClass(String name) {
        return s_preserveClasses.contains(name);
    }

    public static ClassFile getClassFile(String name) throws JiBXException {
        return s_instance.getClassFileImpl(name);
    }

    public static ClassFile requireClassFile(String name) throws JiBXException {
        ClassFile cf = s_instance.getClassFileImpl(name);
        if (cf == null) {
            throw new IllegalArgumentException("Internal error - class " + name + " not found in classpath");
        }
        return cf;
    }

    public static boolean hasClassFile(String name) {
        return ClassCache.s_instance.m_classMap.containsKey(name);
    }

    static void addClassFile(ClassFile cf) {
        ClassCache.s_instance.m_classMap.put(cf.getName(), cf);
    }

    public static File getModifiablePath() {
        if (ClassCache.s_instance.m_roots.length > 0) {
            return ClassCache.s_instance.m_roots[0];
        }
        return null;
    }

    public static void setPaths(String[] paths) {
        s_preserveClasses = new HashSet();
        s_instance = new ClassCache(paths);
    }

    public static class ClassCacheLocator
    implements IClassLocator {
        public boolean isLookupSupported() {
            return true;
        }

        public IClass getClassInfo(String name) {
            try {
                ClassFile cf = ClassCache.getClassFile(name);
                if (cf == null) {
                    return null;
                }
                return new ClassWrapper(this, cf);
            }
            catch (JiBXException e) {
                throw new IllegalStateException("Error loading class " + name + ": " + e.getMessage());
            }
        }

        public IClass getRequiredClassInfo(String name) {
            IClass iclas = this.getClassInfo(name);
            if (iclas == null) {
                throw new IllegalStateException("Internal error: class " + name + " cannot be found");
            }
            return iclas;
        }

        public Class loadClass(String name) {
            return ClassFile.loadClass(name);
        }
    }
}

