/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.path;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import java.util.HashMap;
import java.util.Map;
import org.jinq.rebased.org.objectweb.asm.Type;

public class SymbExSimplifier<I>
extends TypedValueVisitor<I, TypedValue, RuntimeException> {
    final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> additionalComparisonMethods;
    final Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> additionalStaticComparisonMethods;
    final boolean convertAllEquals;
    static Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> comparisonMethods = new HashMap<MethodSignature, TypedValue.ComparisonValue.ComparisonOp>();
    static Map<MethodSignature, TypedValue.MathOpValue.Op> mathMethods;
    static Map<MethodSignature, Type> mathMethodsType;

    public SymbExSimplifier(Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> additionalComparisonMethods, Map<MethodSignature, TypedValue.ComparisonValue.ComparisonOp> additionalStaticComparisonMethods, boolean convertAllEquals) {
        this.additionalComparisonMethods = additionalComparisonMethods;
        this.additionalStaticComparisonMethods = additionalStaticComparisonMethods;
        this.convertAllEquals = convertAllEquals;
    }

    @Override
    public TypedValue defaultValue(TypedValue val, I in) {
        return val;
    }

    private TypedValue comparisonOpValueWithZero(TypedValue.ComparisonValue val, TypedValue.ComparisonValue.ComparisonOp op, TypedValue other) {
        if ((op == TypedValue.ComparisonValue.ComparisonOp.eq || op == TypedValue.ComparisonValue.ComparisonOp.ne) && other instanceof TypedValue.ComparisonValue) {
            if (op != TypedValue.ComparisonValue.ComparisonOp.eq) {
                return other;
            }
            return ((TypedValue.ComparisonValue)other).inverseValue();
        }
        if ((op == TypedValue.ComparisonValue.ComparisonOp.eq || op == TypedValue.ComparisonValue.ComparisonOp.ne) && other.getType() == Type.BOOLEAN_TYPE) {
            if (op != TypedValue.ComparisonValue.ComparisonOp.eq) {
                return other;
            }
            return new TypedValue.NotValue(other);
        }
        if (other instanceof TypedValue.MathOpValue && ((TypedValue.MathOpValue)other).op == TypedValue.MathOpValue.Op.cmp) {
            TypedValue newLeft = ((TypedValue.MathOpValue)other).left;
            TypedValue newRight = ((TypedValue.MathOpValue)other).right;
            return new TypedValue.ComparisonValue(op, newLeft, newRight);
        }
        return val;
    }

    @Override
    public TypedValue comparisonOpValue(TypedValue.ComparisonValue val, I in) {
        TypedValue toReturn;
        if (val.left instanceof ConstantValue.IntegerConstant && val.right instanceof ConstantValue.IntegerConstant) {
            ConstantValue.IntegerConstant left = (ConstantValue.IntegerConstant)val.left;
            ConstantValue.IntegerConstant right = (ConstantValue.IntegerConstant)val.right;
            switch (val.compOp) {
                case eq: {
                    return new ConstantValue.IntegerConstant(left.val == right.val ? 1 : 0);
                }
                case ne: {
                    return new ConstantValue.IntegerConstant(left.val != right.val ? 1 : 0);
                }
            }
        }
        if (val.left instanceof ConstantValue.IntegerConstant && ((ConstantValue.IntegerConstant)val.left).val == 0) {
            TypedValue.ComparisonValue.ComparisonOp newOp;
            switch (val.compOp) {
                case eq: {
                    newOp = TypedValue.ComparisonValue.ComparisonOp.eq;
                    break;
                }
                case ne: {
                    newOp = TypedValue.ComparisonValue.ComparisonOp.ne;
                    break;
                }
                case ge: {
                    newOp = TypedValue.ComparisonValue.ComparisonOp.le;
                    break;
                }
                case gt: {
                    newOp = TypedValue.ComparisonValue.ComparisonOp.lt;
                    break;
                }
                case le: {
                    newOp = TypedValue.ComparisonValue.ComparisonOp.ge;
                    break;
                }
                case lt: {
                    newOp = TypedValue.ComparisonValue.ComparisonOp.gt;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown comparison operator");
                }
            }
            TypedValue toReturn2 = this.comparisonOpValueWithZero(val, newOp, val.right);
            if (toReturn2 != val) {
                return toReturn2;
            }
        }
        if (val.right instanceof ConstantValue.IntegerConstant && ((ConstantValue.IntegerConstant)val.right).val == 0 && (toReturn = this.comparisonOpValueWithZero(val, val.compOp, val.left)) != val) {
            return toReturn;
        }
        return (TypedValue)super.comparisonOpValue(val, in);
    }

    @Override
    public TypedValue staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, I in) {
        MethodSignature sig = val.getSignature();
        if (this.additionalStaticComparisonMethods.containsKey(sig)) {
            return new TypedValue.ComparisonValue(this.additionalStaticComparisonMethods.get(sig), (TypedValue)val.args.get(0), (TypedValue)val.args.get(1));
        }
        return (TypedValue)super.staticMethodCallValue(val, in);
    }

    @Override
    public TypedValue virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, I in) {
        MethodSignature sig = val.getSignature();
        if (comparisonMethods.containsKey(sig)) {
            return new TypedValue.ComparisonValue(comparisonMethods.get(sig), val.base, (TypedValue)val.args.get(0));
        }
        if (this.additionalComparisonMethods.containsKey(sig)) {
            return new TypedValue.ComparisonValue(this.additionalComparisonMethods.get(sig), val.base, (TypedValue)val.args.get(0));
        }
        if (mathMethods.containsKey(sig)) {
            if (mathMethodsType.containsKey(sig)) {
                return new TypedValue.MathOpValue(mathMethods.get(sig), mathMethodsType.get(sig), val.base, (TypedValue)val.args.get(0));
            }
            return new TypedValue.MathOpValue(mathMethods.get(sig), val.base, (TypedValue)val.args.get(0));
        }
        if (this.convertAllEquals && "equals".equals(sig.name) && "(Ljava/lang/Object;)Z".equals(sig.desc)) {
            return new TypedValue.ComparisonValue(TypedValue.ComparisonValue.ComparisonOp.eq, val.base, (TypedValue)val.args.get(0));
        }
        return (TypedValue)this.methodCallValue(val, in);
    }

    static {
        comparisonMethods.put(TransformationClassAnalyzer.stringEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.booleanEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.dateEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.dateBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.dateAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.calendarEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.calendarBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.calendarAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.sqlDateEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.sqlDateBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.sqlDateAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.sqlTimeEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.sqlTimeBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.sqlTimeAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.sqlTimestampEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.sqlTimestampBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.sqlTimestampAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.localDateIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.localDateIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.localDateIsEqual, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.localTimeIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.localTimeIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.localDateTimeIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.localDateTimeIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.localDateTimeIsEqual, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.offsetDateTimeIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.offsetDateTimeIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.offsetDateTimeIsEqual, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.offsetTimeIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.offsetTimeIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.offsetTimeIsEqual, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.zonedDateTimeIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.zonedDateTimeIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.zonedDateTimeIsEqual, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.instantIsBefore, TypedValue.ComparisonValue.ComparisonOp.lt);
        comparisonMethods.put(TransformationClassAnalyzer.instantIsAfter, TypedValue.ComparisonValue.ComparisonOp.gt);
        comparisonMethods.put(TransformationClassAnalyzer.bigDecimalEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        comparisonMethods.put(TransformationClassAnalyzer.uuidEquals, TypedValue.ComparisonValue.ComparisonOp.eq);
        mathMethods = new HashMap<MethodSignature, TypedValue.MathOpValue.Op>();
        mathMethodsType = new HashMap<MethodSignature, Type>();
        mathMethods.put(TransformationClassAnalyzer.stringCompareTo, TypedValue.MathOpValue.Op.cmp);
        mathMethodsType.put(TransformationClassAnalyzer.stringCompareTo, Type.INT_TYPE);
        mathMethods.put(TransformationClassAnalyzer.bigDecimalCompareTo, TypedValue.MathOpValue.Op.cmp);
        mathMethodsType.put(TransformationClassAnalyzer.bigDecimalCompareTo, Type.INT_TYPE);
        mathMethods.put(TransformationClassAnalyzer.bigDecimalAdd, TypedValue.MathOpValue.Op.plus);
        mathMethods.put(TransformationClassAnalyzer.bigDecimalDivide, TypedValue.MathOpValue.Op.div);
        mathMethods.put(TransformationClassAnalyzer.bigDecimalMultiply, TypedValue.MathOpValue.Op.mul);
        mathMethods.put(TransformationClassAnalyzer.bigDecimalSubtract, TypedValue.MathOpValue.Op.minus);
        mathMethods.put(TransformationClassAnalyzer.bigIntegerCompareTo, TypedValue.MathOpValue.Op.cmp);
        mathMethodsType.put(TransformationClassAnalyzer.bigIntegerCompareTo, Type.INT_TYPE);
        mathMethods.put(TransformationClassAnalyzer.bigIntegerAdd, TypedValue.MathOpValue.Op.plus);
        mathMethods.put(TransformationClassAnalyzer.bigIntegerDivide, TypedValue.MathOpValue.Op.div);
        mathMethods.put(TransformationClassAnalyzer.bigIntegerMultiply, TypedValue.MathOpValue.Op.mul);
        mathMethods.put(TransformationClassAnalyzer.bigIntegerSubtract, TypedValue.MathOpValue.Op.minus);
        mathMethods.put(TransformationClassAnalyzer.uuidCompareTo, TypedValue.MathOpValue.Op.cmp);
        mathMethodsType.put(TransformationClassAnalyzer.uuidCompareTo, Type.INT_TYPE);
    }
}

