/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import ch.epfl.labos.iu.orm.queryll2.path.MethodSideEffect;
import ch.epfl.labos.iu.orm.queryll2.path.MethodSideEffectCall;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.FrameWithHelpers;
import ch.epfl.labos.iu.orm.queryll2.symbolic.InterpreterWithArgs;
import ch.epfl.labos.iu.orm.queryll2.symbolic.LambdaFactory;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jinq.rebased.org.objectweb.asm.Handle;
import org.jinq.rebased.org.objectweb.asm.Opcodes;
import org.jinq.rebased.org.objectweb.asm.Type;
import org.jinq.rebased.org.objectweb.asm.tree.AbstractInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.FieldInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.IntInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.LdcInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.MethodInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.TypeInsnNode;
import org.jinq.rebased.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jinq.rebased.org.objectweb.asm.tree.analysis.Value;

public class BasicSymbolicInterpreter
extends InterpreterWithArgs
implements Opcodes {
    FrameWithHelpers linkedFrame;
    BranchHandler branchHandler;
    public TypedValue returnValue = null;
    public List<MethodSideEffect> sideEffects = new ArrayList<MethodSideEffect>();
    MethodChecker methodChecker;

    public BasicSymbolicInterpreter(int api) {
        super(api);
    }

    public void setFrameForAliasingFixups(FrameWithHelpers frame) {
        this.linkedFrame = frame;
    }

    public void setBranchHandler(BranchHandler branchHandler) {
        this.branchHandler = branchHandler;
    }

    public void setMethodChecker(MethodChecker methodChecker) {
        this.methodChecker = methodChecker;
    }

    @Override
    public Value newArg(Type type, int argumentIndex) {
        return new TypedValue.ArgValue(type, argumentIndex);
    }

    @Override
    public Value newThis(Type type) {
        return new TypedValue.ThisValue(type);
    }

    public Value newValue(Type type) {
        assert (type == null);
        return new TypedValue(type);
    }

    public Value copyOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        return value;
    }

    public Value merge(Value v, Value w) {
        return null;
    }

    public Value newOperation(AbstractInsnNode insn) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return new ConstantValue.IntegerConstant(insn.getOpcode() - 2 - 1);
            }
            case 9: 
            case 10: {
                return new ConstantValue.LongConstant(insn.getOpcode() - 9);
            }
            case 11: 
            case 12: 
            case 13: {
                return new ConstantValue.FloatConstant(insn.getOpcode() - 11);
            }
            case 14: 
            case 15: {
                return new ConstantValue.DoubleConstant(insn.getOpcode() - 14);
            }
            case 1: {
                return new ConstantValue.NullConstant();
            }
            case 18: {
                assert (insn instanceof LdcInsnNode);
                LdcInsnNode ldcInsn = (LdcInsnNode)insn;
                Object val = ldcInsn.cst;
                if (val instanceof String) {
                    return new ConstantValue.StringConstant((String)val);
                }
                if (val instanceof Integer) {
                    return new ConstantValue.IntegerConstant((Integer)val);
                }
                if (val instanceof Long) {
                    return new ConstantValue.LongConstant((Long)val);
                }
                if (val instanceof Float) {
                    return new ConstantValue.FloatConstant(((Float)val).floatValue());
                }
                if (val instanceof Double) {
                    return new ConstantValue.DoubleConstant((Double)val);
                }
                if (val instanceof Type) {
                    return new ConstantValue.ClassConstant((Type)val);
                }
                throw new AnalyzerException(insn, "Unhandled bytecode instruction");
            }
            case 187: {
                assert (insn instanceof TypeInsnNode);
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                String className = typeInsn.desc;
                return new TypedValue.NewValue(className);
            }
            case 16: 
            case 17: {
                assert (insn instanceof IntInsnNode);
                IntInsnNode intInsn = (IntInsnNode)insn;
                return new ConstantValue.IntegerConstant(intInsn.operand);
            }
            case 178: {
                assert (insn instanceof FieldInsnNode);
                FieldInsnNode fieldInsn = (FieldInsnNode)insn;
                return new TypedValue.GetStaticFieldValue(fieldInsn.owner, fieldInsn.name, fieldInsn.desc);
            }
        }
        throw new AnalyzerException(insn, "Unhandled bytecode instruction");
    }

    public Value unaryOperation(AbstractInsnNode insn, Value value) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                return null;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                return this.ifOperation(insn, value, new ConstantValue.IntegerConstant(0));
            }
            case 198: 
            case 199: {
                return this.ifOperation(insn, value, new ConstantValue.NullConstant());
            }
            case 192: {
                TypeInsnNode typeInsn = (TypeInsnNode)insn;
                return new TypedValue.CastValue(Type.getObjectType((String)typeInsn.desc), (TypedValue)value);
            }
            case 133: 
            case 140: 
            case 143: {
                return new TypedValue.CastValue(Type.LONG_TYPE, (TypedValue)value);
            }
            case 136: 
            case 139: 
            case 142: {
                return new TypedValue.CastValue(Type.INT_TYPE, (TypedValue)value);
            }
            case 134: 
            case 137: 
            case 144: {
                return new TypedValue.CastValue(Type.FLOAT_TYPE, (TypedValue)value);
            }
            case 135: 
            case 138: 
            case 141: {
                return new TypedValue.CastValue(Type.DOUBLE_TYPE, (TypedValue)value);
            }
            case 116: {
                return new TypedValue.UnaryMathOpValue(TypedValue.UnaryMathOpValue.UnaryOp.neg, Type.INT_TYPE, (TypedValue)value);
            }
            case 117: {
                return new TypedValue.UnaryMathOpValue(TypedValue.UnaryMathOpValue.UnaryOp.neg, Type.LONG_TYPE, (TypedValue)value);
            }
            case 119: {
                return new TypedValue.UnaryMathOpValue(TypedValue.UnaryMathOpValue.UnaryOp.neg, Type.DOUBLE_TYPE, (TypedValue)value);
            }
        }
        throw new AnalyzerException(insn, "Unhandled bytecode instruction");
    }

    public Value binaryOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                return this.ifOperation(insn, value1, value2);
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return new TypedValue.MathOpValue(TypedValue.MathOpValue.Op.minus, (TypedValue)value1, (TypedValue)value2);
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return new TypedValue.MathOpValue(TypedValue.MathOpValue.Op.plus, (TypedValue)value1, (TypedValue)value2);
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new TypedValue.MathOpValue(TypedValue.MathOpValue.Op.mul, (TypedValue)value1, (TypedValue)value2);
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return new TypedValue.MathOpValue(TypedValue.MathOpValue.Op.div, (TypedValue)value1, (TypedValue)value2);
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return new TypedValue.MathOpValue(TypedValue.MathOpValue.Op.cmp, Type.INT_TYPE, (TypedValue)value1, (TypedValue)value2);
            }
            case 112: 
            case 113: {
                return new TypedValue.MathOpValue(TypedValue.MathOpValue.Op.mod, Type.INT_TYPE, (TypedValue)value1, (TypedValue)value2);
            }
        }
        throw new AnalyzerException(insn, "Unhandled bytecode instruction");
    }

    public Value ternaryOperation(AbstractInsnNode insn, Value value1, Value value2, Value value3) throws AnalyzerException {
        switch (insn.getOpcode()) {
            default: 
        }
        throw new AnalyzerException(insn, "Unhandled bytecode instruction");
    }

    public Value naryOperation(AbstractInsnNode insn, List values) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                int n;
                assert (insn instanceof MethodInsnNode);
                MethodInsnNode methodInsn = (MethodInsnNode)insn;
                boolean isVirtualCall = insn.getOpcode() != 184;
                ArrayList<TypedValue> args = new ArrayList<TypedValue>();
                int n2 = n = isVirtualCall ? 1 : 0;
                while (n < values.size()) {
                    args.add((TypedValue)values.get(n));
                    ++n;
                }
                MethodSignature sig = new MethodSignature(methodInsn.owner, methodInsn.name, methodInsn.desc);
                if (isVirtualCall) {
                    MethodCallValue.VirtualMethodCallValue toReturn;
                    TypedValue base = (TypedValue)values.get(0);
                    if (this.methodChecker != null) {
                        OperationSideEffect sideEffect = this.methodChecker.isMethodSafe(sig, base, args);
                        if (sideEffect == OperationSideEffect.UNSAFE) {
                            throw new AnalyzerException(insn, "Unknown method " + sig + " encountered");
                        }
                        if (sideEffect == OperationSideEffect.SAFE) {
                            this.sideEffects.add(new MethodSideEffectCall(sig, base, args));
                        }
                    }
                    if ((toReturn = new MethodCallValue.VirtualMethodCallValue(methodInsn.owner, methodInsn.name, methodInsn.desc, args, base)).isConstructor() && this.linkedFrame != null) {
                        this.linkedFrame.replaceValues(base, toReturn);
                    } else if (this.methodChecker != null && this.methodChecker.isFluentChaining(sig)) {
                        this.linkedFrame.replaceValues(base, toReturn);
                    }
                    return toReturn;
                }
                if (this.methodChecker != null) {
                    OperationSideEffect sideEffect = this.methodChecker.isStaticMethodSafe(sig);
                    if (sideEffect == OperationSideEffect.UNSAFE) {
                        throw new AnalyzerException(insn, "Unknown static method " + sig + " encountered");
                    }
                    if (sideEffect == OperationSideEffect.SAFE) {
                        this.sideEffects.add(new MethodSideEffectCall(sig, null, args));
                    }
                }
                return new MethodCallValue.StaticMethodCallValue(methodInsn.owner, methodInsn.name, methodInsn.desc, args);
            }
            case 186: {
                assert (insn instanceof InvokeDynamicInsnNode);
                InvokeDynamicInsnNode invokeInsn = (InvokeDynamicInsnNode)insn;
                if ("java/lang/invoke/LambdaMetafactory".equals(invokeInsn.bsm.getOwner()) && "altMetafactory".equals(invokeInsn.bsm.getName()) && "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;".equals(invokeInsn.bsm.getDesc())) {
                    Handle lambdaMethod = (Handle)invokeInsn.bsmArgs[1];
                    Type functionalInterface = Type.getReturnType((String)invokeInsn.desc);
                    return new LambdaFactory(functionalInterface, lambdaMethod, new ArrayList<TypedValue>(values));
                }
                if ("java/lang/invoke/StringConcatFactory".equals(invokeInsn.bsm.getOwner()) && "makeConcatWithConstants".equals(invokeInsn.bsm.getName()) && "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/invoke/CallSite;".equals(invokeInsn.bsm.getDesc())) {
                    Collections.reverse(values);
                    return new MethodCallValue.StringConcatFactoryValue(invokeInsn.desc, (String)invokeInsn.bsmArgs[0], values);
                }
                throw new AnalyzerException(insn, "Unknown invokedynamic " + invokeInsn.bsm + " encountered");
            }
        }
        throw new AnalyzerException(insn, "Unhandled bytecode instruction");
    }

    public void returnOperation(AbstractInsnNode insn, Value value, Value expected) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.returnValue = (TypedValue)value;
                break;
            }
        }
    }

    public Value ifOperation(AbstractInsnNode insn, Value value1, Value value2) throws AnalyzerException {
        TypedValue.ComparisonValue.ComparisonOp op;
        switch (insn.getOpcode()) {
            case 153: 
            case 159: {
                op = TypedValue.ComparisonValue.ComparisonOp.eq;
                break;
            }
            case 154: 
            case 160: {
                op = TypedValue.ComparisonValue.ComparisonOp.ne;
                break;
            }
            case 155: 
            case 161: {
                op = TypedValue.ComparisonValue.ComparisonOp.lt;
                break;
            }
            case 156: 
            case 162: {
                op = TypedValue.ComparisonValue.ComparisonOp.ge;
                break;
            }
            case 157: 
            case 163: {
                op = TypedValue.ComparisonValue.ComparisonOp.gt;
                break;
            }
            case 158: 
            case 164: {
                op = TypedValue.ComparisonValue.ComparisonOp.le;
                break;
            }
            case 165: 
            case 198: {
                op = TypedValue.ComparisonValue.ComparisonOp.eq;
                break;
            }
            case 166: 
            case 199: {
                op = TypedValue.ComparisonValue.ComparisonOp.ne;
                break;
            }
            default: {
                throw new AnalyzerException(insn, "Unhandled bytecode instruction");
            }
        }
        TypedValue.ComparisonValue toReturn = new TypedValue.ComparisonValue(op, (TypedValue)value1, (TypedValue)value2);
        if (this.branchHandler != null) {
            this.branchHandler.ifInstruction(insn, toReturn);
        }
        return toReturn;
    }

    public static interface MethodChecker {
        public OperationSideEffect isMethodSafe(MethodSignature var1, TypedValue var2, List<TypedValue> var3);

        public OperationSideEffect isStaticMethodSafe(MethodSignature var1);

        public boolean isFluentChaining(MethodSignature var1);

        public boolean isPutFieldAllowed();
    }

    public static enum OperationSideEffect {
        NONE,
        UNSAFE,
        SAFE;

    }

    public static interface BranchHandler {
        public void ifInstruction(AbstractInsnNode var1, TypedValue.ComparisonValue var2);
    }
}

