/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.labos.iu.orm.queryll2.symbolic;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jinq.rebased.org.objectweb.asm.Type;

public class MethodSignature {
    public String owner;
    public String name;
    public String desc;

    public MethodSignature(String owner, String name, String desc) {
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public Type getOwnerType() {
        return Type.getObjectType((String)this.owner);
    }

    public Type getReturnType() {
        return Type.getReturnType((String)this.desc);
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature m = (MethodSignature)o;
        return m.desc.equals(this.desc) && m.name.equals(this.name) && m.owner.equals(this.owner);
    }

    public boolean equals(String owner, String name, String desc) {
        return this.equals(new MethodSignature(owner, name, desc));
    }

    public int hashCode() {
        return this.owner.hashCode() ^ this.name.hashCode() ^ this.desc.hashCode();
    }

    public String toString() {
        return this.owner + ":" + this.name + this.desc;
    }

    public static MethodSignature fromMethod(Method m) {
        return new MethodSignature(Type.getInternalName(m.getDeclaringClass()), m.getName(), Type.getMethodDescriptor((Method)m));
    }

    public static MethodSignature fromConstructor(Constructor<?> m) {
        return new MethodSignature(Type.getInternalName(m.getDeclaringClass()), "<init>", Type.getConstructorDescriptor(m));
    }
}

