/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.transform.JPQLNoLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SymbExArgumentHandler;

public class LimitSkipTransform
extends JPQLNoLambdaQueryTransform {
    boolean isLimit;
    long constraint;

    public LimitSkipTransform(JPQLQueryTransformConfiguration config, boolean isLimit, long n) {
        super(config);
        this.constraint = n;
        this.isLimit = isLimit;
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        if (query instanceof SelectFromWhere) {
            SelectFromWhere sfw = (SelectFromWhere)query;
            if (this.isLimit && sfw.limit >= 0L) {
                throw new IllegalArgumentException("Cannot limit a query more than once");
            }
            if (!this.isLimit && sfw.skip >= 0L) {
                throw new IllegalArgumentException("Cannot skip in a query more than once");
            }
            SelectOnly toReturn = sfw.shallowCopy();
            if (this.isLimit) {
                ((SelectFromWhere)toReturn).limit = this.constraint;
            } else {
                if (((SelectFromWhere)toReturn).limit >= 0L) {
                    ((SelectFromWhere)toReturn).limit -= this.constraint;
                }
                ((SelectFromWhere)toReturn).skip = this.constraint;
            }
            return toReturn;
        }
        throw new QueryTransformException("Existing query cannot be transformed further");
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return LimitSkipTransform.class.getName() + ":" + this.isLimit + ":" + this.constraint;
    }
}

