/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import org.jinq.jpa.jpqlquery.BinaryExpression;
import org.jinq.jpa.jpqlquery.ConstantExpression;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.OffsetLambdaIndexInExpressionsVisitor;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.jpqlquery.UnaryExpression;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JPQLTwoQueryMergeQueryTransform;
import org.jinq.jpa.transform.QueryTransformException;

public class SetOperationEmulationTransform
extends JPQLTwoQueryMergeQueryTransform {
    SetOperationType type = SetOperationType.OR_UNION;

    public SetOperationEmulationTransform(JPQLQueryTransformConfiguration config, SetOperationType type) {
        super(config);
        this.type = type;
    }

    @Override
    public <U, V, W> JPQLQuery<W> apply(JPQLQuery<U> query1, JPQLQuery<V> query2, int lambdaOffset) throws QueryTransformException {
        if (query1.isSelectFromWhere() && query2.isSelectFromWhere()) {
            SelectFromWhere sfw1 = (SelectFromWhere)query1;
            SelectFromWhere sfw2 = (SelectFromWhere)query2;
            if (!sfw1.cols.isSingleColumn() || !sfw2.cols.isSingleColumn()) {
                throw new QueryTransformException("Cannot only merge queries that return one field of data");
            }
            if (!sfw1.cols.getOnlyColumn().equals(sfw2.cols.getOnlyColumn())) {
                throw new QueryTransformException("Cannot only merge queries that return the exact same SELECTed data");
            }
            if (sfw1.froms.size() != sfw2.froms.size()) {
                throw new QueryTransformException("Cannot only merge queries that are based on the same data source");
            }
            for (int n = 0; n < sfw1.froms.size(); ++n) {
                if (sfw1.froms.get(n).equals(sfw2.froms.get(n))) continue;
                throw new QueryTransformException("Cannot only merge queries that are based on the same data source");
            }
            SelectOnly merged = sfw1.shallowCopy();
            if (((SelectFromWhere)merged).where == null && sfw2.where == null) {
                switch (this.type) {
                    case AND_NOT_EXCEPT: {
                        ((SelectFromWhere)merged).where = new BinaryExpression("=", new ConstantExpression("1"), new ConstantExpression("0"));
                    }
                }
            }
            if (((SelectFromWhere)merged).where == null || sfw2.where == null) {
                Expression offsetWhere = ((SelectFromWhere)merged).where;
                if (sfw2.where != null) {
                    offsetWhere = sfw2.where.copy();
                    offsetWhere.visit(new OffsetLambdaIndexInExpressionsVisitor(lambdaOffset));
                }
                switch (this.type) {
                    case AND_INTERSECT: {
                        ((SelectFromWhere)merged).where = offsetWhere;
                        break;
                    }
                    case OR_UNION: {
                        ((SelectFromWhere)merged).where = null;
                        break;
                    }
                    case AND_NOT_EXCEPT: {
                        ((SelectFromWhere)merged).where = ((SelectFromWhere)merged).where == null ? UnaryExpression.prefix("NOT", offsetWhere) : new BinaryExpression("=", new ConstantExpression("1"), new ConstantExpression("0"));
                    }
                }
            } else {
                Expression offsetWhere = sfw2.where.copy();
                offsetWhere.visit(new OffsetLambdaIndexInExpressionsVisitor(lambdaOffset));
                switch (this.type) {
                    case AND_NOT_EXCEPT: {
                        ((SelectFromWhere)merged).where = new BinaryExpression("AND", ((SelectFromWhere)merged).where, UnaryExpression.prefix("NOT", offsetWhere));
                        break;
                    }
                    case AND_INTERSECT: 
                    case OR_UNION: {
                        ((SelectFromWhere)merged).where = new BinaryExpression(this.type.op, ((SelectFromWhere)merged).where, offsetWhere);
                    }
                }
            }
            return merged;
        }
        throw new QueryTransformException("Cannot merge the two query streams");
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return SetOperationEmulationTransform.class.getName() + ":" + this.type.name();
    }

    public static enum SetOperationType {
        OR_UNION("OR"),
        AND_INTERSECT("AND"),
        AND_NOT_EXCEPT("EXCEPT");

        String op;

        private SetOperationType(String op) {
            this.op = op;
        }
    }
}

