/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.TransformationClassAnalyzer;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.LambdaFactory;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodCallValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.MethodSignature;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.From;
import org.jinq.jpa.jpqlquery.FromAliasExpression;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.ReadFieldExpression;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SimpleRowReader;
import org.jinq.jpa.transform.DistinctTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.JoinTransform;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.MetamodelUtil;
import org.jinq.jpa.transform.MethodChecker;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectTransform;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToColumns;
import org.jinq.jpa.transform.WhereTransform;
import org.jinq.rebased.org.objectweb.asm.Type;

public class SymbExToSubQuery
extends TypedValueVisitor<SymbExPassDown, JPQLQuery<?>, TypedValueVisitorException> {
    final SymbExArgumentHandler argHandler;
    JPQLQueryTransformConfiguration config = new JPQLQueryTransformConfiguration();
    boolean isExpectingStream;

    SymbExToSubQuery(JPQLQueryTransformConfiguration config, SymbExArgumentHandler argumentHandler, boolean isExpectingStream) {
        this.config = config;
        this.argHandler = argumentHandler;
        this.isExpectingStream = isExpectingStream;
    }

    public JPQLQuery<?> defaultValue(TypedValue val, SymbExPassDown in) throws TypedValueVisitorException {
        throw new TypedValueVisitorException("Unhandled symbolic execution operation: " + val);
    }

    public JPQLQuery<?> argValue(TypedValue.ArgValue val, SymbExPassDown in) throws TypedValueVisitorException {
        int index = val.getIndex();
        return this.argHandler.handleSubQueryArg(index, val.getType());
    }

    private boolean isStreamMethod(MethodSignature sig) {
        return sig.equals((Object)MethodChecker.streamDistinct) || sig.equals((Object)MethodChecker.streamSelect) || sig.equals((Object)MethodChecker.streamSelectWithSource) || sig.equals((Object)MethodChecker.streamSelectAll) || sig.equals((Object)MethodChecker.streamSelectAllWithSource) || sig.equals((Object)MethodChecker.streamSelectAllList) || sig.equals((Object)MethodChecker.streamWhere) || sig.equals((Object)MethodChecker.streamWhereWithSource) || sig.equals((Object)MethodChecker.streamJoin) || sig.equals((Object)MethodChecker.streamJoinWithSource) || sig.equals((Object)MethodChecker.streamJoinList);
    }

    public JPQLQuery<?> virtualMethodCallValue(MethodCallValue.VirtualMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        MethodSignature sig = val.getSignature();
        if (this.isExpectingStream) {
            if (MetamodelUtil.inQueryStream.equals((Object)sig)) {
                return this.handleInQueryStreamSource(val.base, (TypedValue)val.args.get(0));
            }
            if (this.isStreamMethod(sig)) {
                SymbExPassDown passdown = SymbExPassDown.with((TypedValue)val, false);
                JPQLQuery subQuery = (JPQLQuery)val.base.visit((TypedValueVisitor)this, (Object)passdown);
                LambdaAnalysis lambda = null;
                if (val.args.size() > 0) {
                    if (!(val.args.get(0) instanceof LambdaFactory)) {
                        throw new TypedValueVisitorException("Expecting a lambda factory for aggregate method");
                    }
                    LambdaFactory lambdaFactory = (LambdaFactory)val.args.get(0);
                    try {
                        lambda = LambdaAnalysis.analyzeMethod(this.config.metamodel, this.config.alternateClassLoader, this.config.isObjectEqualsSafe, this.config.isAllEqualsSafe, this.config.isCollectionContainsSafe, lambdaFactory.getLambdaMethod(), lambdaFactory.getCapturedArgs(), true);
                    }
                    catch (Exception e) {
                        throw new TypedValueVisitorException("Could not analyze the lambda code", (Throwable)e);
                    }
                }
                try {
                    JPQLQuery transformedQuery;
                    if (sig.equals((Object)MethodChecker.streamDistinct)) {
                        DistinctTransform transform = new DistinctTransform(this.config);
                        transformedQuery = transform.apply(subQuery, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamSelect)) {
                        SelectTransform transform = new SelectTransform(this.config, false);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamSelectWithSource)) {
                        SelectTransform transform = new SelectTransform(this.config, true);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamSelectAll)) {
                        JoinTransform transform = new JoinTransform(this.config).setJoinAsPairs(false);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamSelectAllWithSource)) {
                        JoinTransform transform = new JoinTransform(this.config).setJoinAsPairs(false).setWithSource(true);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamSelectAllList)) {
                        JoinTransform transform = new JoinTransform(this.config).setJoinAsPairs(false).setIsExpectingStream(false);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamWhere)) {
                        WhereTransform transform = new WhereTransform(this.config, false);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamWhereWithSource)) {
                        WhereTransform transform = new WhereTransform(this.config, true);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamJoin)) {
                        JoinTransform transform = new JoinTransform(this.config);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamJoinWithSource)) {
                        JoinTransform transform = new JoinTransform(this.config).setWithSource(true);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else if (sig.equals((Object)MethodChecker.streamJoinList)) {
                        JoinTransform transform = new JoinTransform(this.config).setIsExpectingStream(false);
                        transformedQuery = transform.apply(subQuery, lambda, this.argHandler);
                    } else {
                        throw new TypedValueVisitorException("Unknown stream operation: " + sig);
                    }
                    return transformedQuery;
                }
                catch (QueryTransformException e) {
                    throw new TypedValueVisitorException("Subquery could not be transformed.", (Throwable)e);
                }
            }
        } else {
            JPQLQuery<?> nLink = this.handlePossibleNavigationalLink((TypedValue)val, true, in);
            if (nLink != null) {
                return nLink;
            }
        }
        return (JPQLQuery)super.virtualMethodCallValue(val, (Object)in);
    }

    protected JPQLQuery<?> handleInQueryStreamSource(TypedValue methodBase, TypedValue entity) throws TypedValueVisitorException {
        if (!(methodBase instanceof TypedValue.ArgValue)) {
            throw new TypedValueVisitorException("InQueryStreamSource comes from unknown source");
        }
        int index = ((TypedValue.ArgValue)methodBase).getIndex();
        if (!this.argHandler.checkIsInQueryStreamSource(index)) {
            throw new TypedValueVisitorException("InQueryStreamSource comes from unknown source");
        }
        if (!(entity instanceof ConstantValue.ClassConstant)) {
            throw new TypedValueVisitorException("Streaming an unknown type");
        }
        Type type = ((ConstantValue.ClassConstant)entity).val;
        String entityName = this.config.metamodel.entityNameFromClassName(type.getClassName());
        if (entityName == null) {
            throw new TypedValueVisitorException("Streaming an unknown type");
        }
        return JPQLQuery.findAllEntities(entityName);
    }

    protected JPQLQuery<?> handlePossibleNavigationalLink(TypedValue unknownVal, boolean expectingPluralLink, SymbExPassDown in) throws TypedValueVisitorException {
        if (unknownVal instanceof MethodCallValue.VirtualMethodCallValue) {
            MethodCallValue.VirtualMethodCallValue val = (MethodCallValue.VirtualMethodCallValue)unknownVal;
            MethodSignature sig = val.getSignature();
            if (expectingPluralLink && this.config.metamodel.isPluralAttributeLinkMethod(sig) || !expectingPluralLink && this.config.metamodel.isSingularAttributeFieldMethod(sig) && this.config.metamodel.isFieldMethodAssociationType(sig)) {
                Expression expr;
                SymbExPassDown passdown;
                String linkName = expectingPluralLink ? this.config.metamodel.nLinkMethodToLinkName(sig) : this.config.metamodel.fieldMethodToFieldName(sig);
                SymbExToColumns translator = this.config.newSymbExToColumns(this.argHandler);
                ColumnExpressions nLinkBase = (ColumnExpressions)val.base.visit((TypedValueVisitor)translator, (Object)(passdown = SymbExPassDown.with((TypedValue)val, false)));
                if (nLinkBase.isSingleColumn() && !((expr = nLinkBase.getOnlyColumn()) instanceof FromAliasExpression) && !(expr instanceof ReadFieldExpression)) {
                    return null;
                }
                SelectFromWhere query = new SelectFromWhere();
                From from = From.forNavigationalLinks(new ReadFieldExpression(nLinkBase.getOnlyColumn(), linkName));
                query.cols = ColumnExpressions.singleColumn(new SimpleRowReader(), new FromAliasExpression(from));
                query.froms.add(from);
                return query;
            }
        }
        return null;
    }

    public JPQLQuery<?> staticMethodCallValue(MethodCallValue.StaticMethodCallValue val, SymbExPassDown in) throws TypedValueVisitorException {
        JPQLQuery<?> nLink;
        MethodSignature sig = val.getSignature();
        if (sig.equals((Object)TransformationClassAnalyzer.streamFrom)) {
            JPQLQuery<?> nLink2 = this.handlePossibleNavigationalLink((TypedValue)val.args.get(0), true, in);
            if (nLink2 != null) {
                return nLink2;
            }
        } else if (sig.equals((Object)TransformationClassAnalyzer.streamOf) && (nLink = this.handlePossibleNavigationalLink((TypedValue)val.args.get(0), false, in)) != null) {
            return nLink;
        }
        return (JPQLQuery)super.staticMethodCallValue(val, (Object)in);
    }
}

