/*
 * Decompiled with CFR 0.152.
 */
package org.jinq.jpa.transform;

import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysis;
import ch.epfl.labos.iu.orm.queryll2.path.PathAnalysisSimplifier;
import ch.epfl.labos.iu.orm.queryll2.symbolic.ConstantValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValue;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitor;
import ch.epfl.labos.iu.orm.queryll2.symbolic.TypedValueVisitorException;
import java.util.ArrayList;
import java.util.List;
import org.jinq.jpa.jpqlquery.BinaryExpression;
import org.jinq.jpa.jpqlquery.ColumnExpressions;
import org.jinq.jpa.jpqlquery.ConstantExpression;
import org.jinq.jpa.jpqlquery.Expression;
import org.jinq.jpa.jpqlquery.GroupedSelectFromWhere;
import org.jinq.jpa.jpqlquery.JPQLQuery;
import org.jinq.jpa.jpqlquery.SelectFromWhere;
import org.jinq.jpa.jpqlquery.SelectOnly;
import org.jinq.jpa.transform.JPQLOneLambdaQueryTransform;
import org.jinq.jpa.transform.JPQLQueryTransformConfiguration;
import org.jinq.jpa.transform.LambdaAnalysis;
import org.jinq.jpa.transform.LambdaParameterArgumentHandler;
import org.jinq.jpa.transform.QueryTransformException;
import org.jinq.jpa.transform.SelectFromWhereLambdaArgumentHandler;
import org.jinq.jpa.transform.SymbExArgumentHandler;
import org.jinq.jpa.transform.SymbExPassDown;
import org.jinq.jpa.transform.SymbExToColumns;

public class WhereTransform
extends JPQLOneLambdaQueryTransform {
    boolean withSource;

    public WhereTransform(JPQLQueryTransformConfiguration config, boolean withSource) {
        super(config);
        this.withSource = withSource;
    }

    @Override
    public <U, V> JPQLQuery<U> apply(JPQLQuery<V> query, LambdaAnalysis where, SymbExArgumentHandler parentArgumentScope) throws QueryTransformException {
        try {
            if (query.canSelectWhere()) {
                SelectFromWhere sfw = (SelectFromWhere)query;
                Expression methodExpr = this.computeWhereReturnExpr(where, sfw, parentArgumentScope);
                SelectOnly toReturn = sfw.shallowCopy();
                ((SelectFromWhere)toReturn).where = sfw.where == null ? methodExpr : new BinaryExpression("AND", sfw.where, methodExpr);
                return toReturn;
            }
            if (query.canSelectHaving()) {
                GroupedSelectFromWhere sfw = (GroupedSelectFromWhere)query;
                Expression methodExpr = this.computeWhereReturnExpr(where, sfw, parentArgumentScope);
                SelectFromWhere toReturn = sfw.shallowCopy();
                ((GroupedSelectFromWhere)toReturn).having = sfw.having == null ? methodExpr : new BinaryExpression("AND", sfw.having, methodExpr);
                return toReturn;
            }
            throw new QueryTransformException("Existing query cannot be transformed further");
        }
        catch (TypedValueVisitorException e) {
            throw new QueryTransformException(e);
        }
    }

    private <V> Expression computeWhereReturnExpr(LambdaAnalysis where, SelectFromWhere<V> sfw, SymbExArgumentHandler parentArgumentScope) throws TypedValueVisitorException, QueryTransformException {
        return WhereTransform.computeWhereReturnExpr(this.config, where, sfw, SelectFromWhereLambdaArgumentHandler.fromSelectFromWhere(sfw, where, this.config.metamodel, parentArgumentScope, this.withSource));
    }

    public static <V> Expression computeWhereReturnExpr(JPQLQueryTransformConfiguration config, LambdaAnalysis where, SelectFromWhere<V> sfw, LambdaParameterArgumentHandler argumentHandler) throws TypedValueVisitorException, QueryTransformException {
        SymbExToColumns translator = config.newSymbExToColumns(argumentHandler);
        ArrayList<List<TypedValue>> disjunction = new ArrayList<List<TypedValue>>();
        for (int n = 0; n < where.symbolicAnalysis.paths.size(); ++n) {
            ArrayList<TypedValue> clauses = new ArrayList<TypedValue>();
            PathAnalysis pathAnalysis = (PathAnalysis)where.symbolicAnalysis.paths.get(n);
            TypedValue returnVal = PathAnalysisSimplifier.simplifyBoolean((TypedValue)pathAnalysis.getReturnValue(), config.getComparisonMethods(), config.getComparisonStaticMethods(), (boolean)config.isAllEqualsSafe);
            if (returnVal instanceof ConstantValue.BooleanConstant) {
                if (!((ConstantValue.BooleanConstant)returnVal).val) continue;
                returnVal = null;
            }
            if (returnVal != null) {
                clauses.add(returnVal);
            }
            WhereTransform.pathConditionsToClauses(pathAnalysis, clauses);
            disjunction.add(clauses);
        }
        if (disjunction.isEmpty()) {
            return new BinaryExpression("=", new ConstantExpression("1"), new ConstantExpression("0"));
        }
        WhereTransform.checkForOrChain(disjunction);
        BinaryExpression methodExpr = null;
        for (List list : disjunction) {
            Expression pathExpr = null;
            for (TypedValue clause : list) {
                SymbExPassDown passdown;
                ColumnExpressions col = (ColumnExpressions)clause.visit((TypedValueVisitor)translator, (Object)(passdown = SymbExPassDown.with(null, true)));
                if (!col.isSingleColumn()) {
                    throw new TypedValueVisitorException("Expecting a single column result for path condition");
                }
                Expression expr = col.getOnlyColumn();
                if (pathExpr == null) {
                    pathExpr = expr;
                    continue;
                }
                pathExpr = new BinaryExpression("AND", pathExpr, expr);
            }
            if (methodExpr != null) {
                methodExpr = new BinaryExpression("OR", methodExpr, pathExpr);
                continue;
            }
            methodExpr = pathExpr;
        }
        return methodExpr;
    }

    private static void checkForOrChain(List<List<TypedValue>> disjunction) {
        List<TypedValue> conjunction;
        ArrayList<TypedValue> canIgnoreClauses = new ArrayList<TypedValue>();
        for (int n = 0; n < disjunction.size() && (conjunction = disjunction.get(n)).size() == 1; ++n) {
            TypedValue not = TypedValue.NotValue.invert((TypedValue)conjunction.get(0));
            canIgnoreClauses.add(not);
            for (int i = n + 1; i < disjunction.size(); ++i) {
                disjunction.get(i).remove(not);
            }
        }
    }

    @Override
    public String getTransformationTypeCachingTag() {
        return WhereTransform.class.getName();
    }
}

