/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.common;

import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class ToolingProvider {
    private static ThreadLocal<ToolingProvider> tooling = new ThreadLocal();
    private boolean isInitialitzed = false;
    private final ProcessingEnvironment processingEnvironment;
    private final Elements elements;
    private final Filer filer;
    private final Messager messager;
    private final Types types;

    public static ToolingProvider getTooling() {
        ToolingProvider toolingProvider = tooling.get();
        if (toolingProvider == null || !toolingProvider.isInitialitzed) {
            throw new IllegalStateException("ToolingProvider is not initialized. Must call setTooling first.");
        }
        return toolingProvider;
    }

    public static void setTooling(ProcessingEnvironment processingEnvironment) {
        tooling.set(new ToolingProvider(processingEnvironment));
    }

    public static void clearTooling() {
        tooling.remove();
    }

    public ToolingProvider(ProcessingEnvironment processingEnv) {
        if (processingEnv == null) {
            throw new IllegalArgumentException("Passed ProcessingEnvironment must not be null");
        }
        this.isInitialitzed = true;
        this.processingEnvironment = processingEnv;
        this.messager = processingEnv.getMessager();
        this.types = processingEnv.getTypeUtils();
        this.filer = processingEnv.getFiler();
        this.elements = processingEnv.getElementUtils();
    }

    public Elements getElements() {
        return this.elements;
    }

    public Filer getFiler() {
        return this.filer;
    }

    public Messager getMessager() {
        return this.messager;
    }

    public Types getTypes() {
        return this.types;
    }

    public ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment;
    }
}

