/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating.templateblocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jmolecules.annotation.processor.aptk.templating.NextDetectedBlockResult;
import org.jmolecules.annotation.processor.aptk.templating.exceptions.MissingClosingTagException;

public enum TemplateBlockType {
    BINDER(false),
    PLAIN_TEXT(false),
    DYNAMIC_TEXT(true),
    STATIC(true, "static", false),
    FOR(true, "for", true),
    IF(true, "if", true),
    INCLUDE(true, "include", true);

    private final boolean usedForBlockSearch;
    private final boolean isControlBlock;
    private final Boolean hasAttributes;
    private final String controlBlockCommand;
    private final Pattern blockDetectionPattern;

    private TemplateBlockType(boolean usedForBlockSearch, String controlBlockCommand, Boolean hasAttributes) {
        this.usedForBlockSearch = usedForBlockSearch;
        this.controlBlockCommand = controlBlockCommand;
        this.isControlBlock = controlBlockCommand != null;
        this.hasAttributes = hasAttributes != null ? hasAttributes : false;
        this.blockDetectionPattern = !this.isControlBlock ? Pattern.compile("[$][{]\\s*((?:\\w|.)*?)\\s*[}]") : (hasAttributes != false ? Pattern.compile("[!][{]" + controlBlockCommand + "\\s+(.*?)\\s*[}]") : Pattern.compile("[!][{]" + controlBlockCommand + "\\s*[}]"));
    }

    private TemplateBlockType(boolean usedForBlockSearch) {
        this(usedForBlockSearch, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public static NextDetectedBlockResult getNextBlock(String templateString) {
        block11: {
            block10: {
                block12: {
                    block13: {
                        bestStartIndex = -1;
                        endIndex = -1;
                        result = null;
                        attributes = null;
                        for (TemplateBlockType templateBlockType : TemplateBlockType.values()) {
                            if (!templateBlockType.usedForBlockSearch || !(matcher = templateBlockType.blockDetectionPattern.matcher(templateString)).find()) continue;
                            if (result == null) {
                                bestStartIndex = matcher.start();
                                endIndex = matcher.end();
                                result = templateBlockType;
                                if (!templateBlockType.hasAttributes.booleanValue()) continue;
                                attributes = matcher.group(1);
                                continue;
                            }
                            if (bestStartIndex <= matcher.start()) continue;
                            bestStartIndex = matcher.start();
                            endIndex = matcher.end();
                            result = templateBlockType;
                            if (!templateBlockType.hasAttributes.booleanValue()) continue;
                            attributes = matcher.group(1);
                        }
                        content = null;
                        remainingString = null;
                        if (result == null || !result.usedForBlockSearch) break block11;
                        templateStringAfterStartTag = templateString.substring(endIndex);
                        if (TemplateBlockType.STATIC != result) break block12;
                        staticEndTagMatcher = TemplateBlockType.STATIC.getEndControlBlockPattern().matcher(templateStringAfterStartTag);
                        if (!staticEndTagMatcher.find()) break block13;
                        content = templateStringAfterStartTag.substring(0, staticEndTagMatcher.start());
                        remainingString = templateStringAfterStartTag.substring(staticEndTagMatcher.end());
                        break block11;
                    }
                    throw new MissingClosingTagException("Cannot find closing tag for " + result.name() + " control block");
                }
                if (!result.isControlBlock()) break block11;
                endControlBlockMatcher = result.getEndControlBlockPattern().matcher(templateStringAfterStartTag);
                if (endControlBlockMatcher.find()) {
                    while (TemplateBlockType.controlBlockEmbeddedInStaticBlock(templateStringAfterStartTag, endControlBlockMatcher.start())) {
                        if (endControlBlockMatcher.find(endControlBlockMatcher.end())) continue;
                        throw new MissingClosingTagException("Cannot find closing tag for " + result.name() + " control block");
                    }
                }
                startControlBlockMatcher = null;
                block2: while (true) {
                    startMatcherStartIndex = startControlBlockMatcher != null ? startControlBlockMatcher.end() : 0;
                    tmpContentStr = templateStringAfterStartTag.substring(0, endControlBlockMatcher.start());
                    startControlBlockMatcher = result.getStartControlBlockPattern().matcher(tmpContentStr);
                    foundStartTagInbetween = true;
                    if (startControlBlockMatcher.find(startMatcherStartIndex)) {
                        while (TemplateBlockType.controlBlockEmbeddedInStaticBlock(tmpContentStr, startControlBlockMatcher.start())) {
                            if (startControlBlockMatcher.find(startControlBlockMatcher.end())) continue;
                            foundStartTagInbetween = false;
                            break;
                        }
                    } else {
                        foundStartTagInbetween = false;
                    }
                    if (!foundStartTagInbetween) break block10;
                    if (!endControlBlockMatcher.find(endControlBlockMatcher.end())) continue;
                    do {
                        if (TemplateBlockType.controlBlockEmbeddedInStaticBlock(templateStringAfterStartTag, endControlBlockMatcher.start())) ** break;
                        continue block2;
                    } while (endControlBlockMatcher.find(endControlBlockMatcher.end()));
                    break;
                }
                throw new MissingClosingTagException("Cannot find closing tag for " + result.name() + " control block");
            }
            content = templateStringAfterStartTag.substring(0, endControlBlockMatcher.start());
            remainingString = templateStringAfterStartTag.substring(endControlBlockMatcher.end());
        }
        return result != null ? new NextDetectedBlockResult(result, bestStartIndex, endIndex, attributes, content, remainingString) : null;
    }

    protected static boolean controlBlockEmbeddedInStaticBlock(String templateString, int startIndex) {
        String searchTemplateString = templateString.substring(0, startIndex);
        int lastStartStaticTagIndex = TemplateBlockType.getStartIndexOfLastMatch(searchTemplateString, STATIC.getStartControlBlockPattern());
        int lastEndTagIndex = TemplateBlockType.getStartIndexOfLastMatch(searchTemplateString, STATIC.getEndControlBlockPattern());
        return lastStartStaticTagIndex >= 0 && (lastEndTagIndex < 0 || lastEndTagIndex >= 0 && lastEndTagIndex < lastStartStaticTagIndex);
    }

    private static int getStartIndexOfLastMatch(String text, Pattern pattern) {
        Matcher matcher = pattern.matcher(text);
        int index = -1;
        while (matcher.find(index + 1)) {
            index = matcher.start();
        }
        return index;
    }

    public Pattern getStartControlBlockPattern() {
        return this.isControlBlock ? this.blockDetectionPattern : null;
    }

    public Pattern getEndControlBlockPattern() {
        return this.isControlBlock ? Pattern.compile("[!][{][/]" + this.controlBlockCommand + "\\s*[}]") : null;
    }

    public boolean isControlBlock() {
        return this.isControlBlock;
    }
}

