/*
 * Decompiled with CFR 0.152.
 */
package org.jmolecules.annotation.processor.aptk.templating.templateblocks;

import java.util.Map;
import org.jmolecules.annotation.processor.aptk.templating.expressions.Expression;
import org.jmolecules.annotation.processor.aptk.templating.expressions.ExpressionParser;
import org.jmolecules.annotation.processor.aptk.templating.expressions.operands.Operand;
import org.jmolecules.annotation.processor.aptk.templating.templateblocks.TemplateBlock;
import org.jmolecules.annotation.processor.aptk.templating.templateblocks.TemplateBlockType;

public class VariableTextTemplateBlock
implements TemplateBlock {
    private final String accessPath;

    public VariableTextTemplateBlock(String accessPath) {
        if (accessPath == null || accessPath.trim().isEmpty()) {
            throw new IllegalArgumentException("Passed accessPath must not be null or empty");
        }
        this.accessPath = accessPath;
    }

    @Override
    public TemplateBlockType getTemplateBlockType() {
        return TemplateBlockType.DYNAMIC_TEXT;
    }

    @Override
    public String getContent(Map<String, Object> variables) {
        Expression expression = ExpressionParser.parseExpression(this.accessPath, variables);
        Operand result = expression.evaluateExpression();
        return result.value() != null ? result.value().toString() : null;
    }

    protected String getAccessPath() {
        return this.accessPath;
    }
}

