/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Platform;
import com.jme3.opencl.lwjgl.LwjglDevice;
import com.jme3.opencl.lwjgl.Utils;
import com.jme3.opencl.lwjgl.info.Info;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;

public final class LwjglPlatform
implements Platform {
    final long platform;
    List<LwjglDevice> devices;

    public LwjglPlatform(long platform) {
        this.platform = platform;
    }

    public long getPlatform() {
        return this.platform;
    }

    public List<LwjglDevice> getDevices() {
        if (this.devices == null) {
            this.devices = new ArrayList<LwjglDevice>();
            for (long d : this.getDevices(-1)) {
                this.devices.add(new LwjglDevice(d, this));
            }
        }
        return this.devices;
    }

    private long[] getDevices(int deviceType) {
        int[] count = new int[1];
        int errcode = CL10.clGetDeviceIDs((long)this.platform, (long)deviceType, null, (int[])count);
        if (errcode == -1) {
            return new long[0];
        }
        Utils.checkError(errcode, "clGetDeviceIDs");
        int num_devices = count[0];
        if (num_devices == 0) {
            return new long[0];
        }
        PointerBuffer devices = PointerBuffer.allocateDirect((int)num_devices);
        errcode = CL10.clGetDeviceIDs((long)this.platform, (long)deviceType, (PointerBuffer)devices, (IntBuffer)null);
        Utils.checkError(errcode, "clGetDeviceIDs");
        long[] deviceIDs = new long[num_devices];
        devices.rewind();
        for (int i = 0; i < num_devices; ++i) {
            deviceIDs[i] = devices.get();
        }
        return deviceIDs;
    }

    public String getProfile() {
        return Info.clGetPlatformInfoStringASCII(this.platform, 2304);
    }

    public boolean isFullProfile() {
        return this.getProfile().contains("FULL_PROFILE");
    }

    public boolean isEmbeddedProfile() {
        return this.getProfile().contains("EMBEDDED_PROFILE");
    }

    public String getVersion() {
        return Info.clGetPlatformInfoStringASCII(this.platform, 2305);
    }

    public int getVersionMajor() {
        return Utils.getMajorVersion(this.getVersion(), "OpenCL ");
    }

    public int getVersionMinor() {
        return Utils.getMinorVersion(this.getVersion(), "OpenCL ");
    }

    public String getName() {
        return Info.clGetPlatformInfoStringASCII(this.platform, 2306);
    }

    public String getVendor() {
        return Info.clGetPlatformInfoStringASCII(this.platform, 2307);
    }

    public boolean hasExtension(String extension) {
        return this.getExtensions().contains(extension);
    }

    public boolean hasOpenGLInterop() {
        return this.hasExtension("cl_khr_gl_sharing");
    }

    public Collection<? extends String> getExtensions() {
        return Arrays.asList(Info.clGetPlatformInfoStringASCII(this.platform, 2308).split(" "));
    }

    public String toString() {
        return this.getName();
    }
}

