/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationReader;
import org.jnosql.artemis.ConfigurationSettingsUnit;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsyncFactory;
import org.jnosql.diana.api.document.DocumentCollectionManagerFactory;
import org.jnosql.diana.api.document.DocumentConfiguration;
import org.jnosql.diana.api.document.DocumentConfigurationAsync;

@ApplicationScoped
class DocumentCollectionFactoryProducer {
    @Inject
    private Reflections reflections;
    @Inject
    private Instance<ConfigurationReader> configurationReader;

    DocumentCollectionFactoryProducer() {
    }

    @ConfigurationUnit
    @Produces
    public <T extends DocumentCollectionManager> DocumentCollectionManagerFactory<T> getDocumentConfigurationGenerics(InjectionPoint injectionPoint) {
        return this.getDocumentCollection(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public DocumentCollectionManagerFactory getDocumentConfiguration(InjectionPoint injectionPoint) {
        return this.getDocumentCollection(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public <T extends DocumentCollectionManagerAsync> DocumentCollectionManagerAsyncFactory<T> getDocumentManagerAsyncGenerics(InjectionPoint injectionPoint) {
        return this.getDocumentCollectionAsync(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public DocumentCollectionManagerAsyncFactory getDocumentManagerAsync(InjectionPoint injectionPoint) {
        return this.getDocumentCollectionAsync(injectionPoint);
    }

    private <T extends DocumentCollectionManagerAsync> DocumentCollectionManagerAsyncFactory<T> getDocumentCollectionAsync(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        ConfigurationUnit annotation = this.getConfigurationUnit(injectionPoint, annotated).orElseThrow(() -> new IllegalStateException("The @ConfigurationUnit does not found"));
        ConfigurationSettingsUnit unit = ((ConfigurationReader)this.configurationReader.get()).read(annotation, DocumentConfigurationAsync.class);
        Class configurationClass = (Class)unit.getProvider().orElseThrow(() -> new IllegalStateException("The DocumentConfiguration provider is required in the configuration"));
        DocumentConfigurationAsync documentConfiguration = (DocumentConfigurationAsync)this.reflections.newInstance(configurationClass);
        return documentConfiguration.getAsync(unit.getSettings());
    }

    private <T extends DocumentCollectionManager> DocumentCollectionManagerFactory<T> getDocumentCollection(InjectionPoint injectionPoint) {
        Annotated annotated = injectionPoint.getAnnotated();
        ConfigurationUnit annotation = this.getConfigurationUnit(injectionPoint, annotated).orElseThrow(() -> new IllegalStateException("The @ConfigurationUnit does not found"));
        ConfigurationSettingsUnit unit = ((ConfigurationReader)this.configurationReader.get()).read(annotation, DocumentConfiguration.class);
        Class configurationClass = (Class)unit.getProvider().orElseThrow(() -> new IllegalStateException("The DocumentConfiguration provider is required in the configuration"));
        DocumentConfiguration configuration = (DocumentConfiguration)this.reflections.newInstance(configurationClass);
        return configuration.get(unit.getSettings());
    }

    private Optional<ConfigurationUnit> getConfigurationUnit(InjectionPoint injectionPoint, Annotated annotated) {
        if (annotated == null) {
            return injectionPoint.getQualifiers().stream().filter(annotation -> ConfigurationUnit.class.equals(annotation.annotationType())).map(ConfigurationUnit.class::cast).findFirst();
        }
        return Optional.ofNullable(annotated.getAnnotation(ConfigurationUnit.class));
    }
}

