/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.Param;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.Query;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.query.DocumentQueryDeleteParser;
import org.jnosql.artemis.document.query.DocumentQueryParser;
import org.jnosql.artemis.document.query.DocumentRepositoryType;
import org.jnosql.artemis.document.query.ReturnTypeConverterUtil;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.DocumentQueryBuilder;

public abstract class AbstractDocumentRepositoryProxy<T>
implements InvocationHandler {
    protected abstract Repository getRepository();

    protected abstract DocumentQueryParser getQueryParser();

    protected abstract DocumentTemplate getTemplate();

    protected abstract DocumentQueryDeleteParser getDeleteParser();

    protected abstract ClassRepresentation getClassRepresentation();

    protected abstract Converters getConverters();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        DocumentRepositoryType type = DocumentRepositoryType.of(method, args);
        Class typeClass = this.getClassRepresentation().getClassInstance();
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case FIND_BY: {
                DocumentQuery query = this.getQueryParser().parse(methodName, args, this.getClassRepresentation(), this.getConverters());
                return ReturnTypeConverterUtil.returnObject(query, this.getTemplate(), typeClass, method);
            }
            case FIND_ALL: {
                return ReturnTypeConverterUtil.returnObject(DocumentQueryBuilder.select().from(this.getClassRepresentation().getName()).build(), this.getTemplate(), typeClass, method);
            }
            case DELETE_BY: {
                this.getTemplate().delete(this.getDeleteParser().parse(methodName, args, this.getClassRepresentation(), this.getConverters()));
                return null;
            }
            case QUERY: {
                DocumentQuery documentQuery = DocumentRepositoryType.getQuery(args).get();
                return ReturnTypeConverterUtil.returnObject(documentQuery, this.getTemplate(), typeClass, method);
            }
            case QUERY_DELETE: {
                DocumentDeleteQuery deleteQuery = DocumentRepositoryType.getDeleteQuery(args).get();
                this.getTemplate().delete(deleteQuery);
                return Void.class;
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                return this.getJnosqlQuery(method, args, typeClass);
            }
        }
        return Void.class;
    }

    private Object getJnosqlQuery(Method method, Object[] args, Class<?> typeClass) {
        List entities;
        String value = method.getAnnotation(Query.class).value();
        Map<String, Object> params = this.getParams(method, args);
        if (params.isEmpty()) {
            entities = this.getTemplate().query(value);
        } else {
            PreparedStatement prepare = this.getTemplate().prepare(value);
            params.entrySet().stream().forEach(e -> prepare.bind((String)e.getKey(), e.getValue()));
            entities = prepare.getResultList();
        }
        return ReturnTypeConverterUtil.returnObject(entities, typeClass, method);
    }

    private Map<String, Object> getParams(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int index = 0; index < parameters.length; ++index) {
            Parameter parameter = parameters[index];
            Param param = parameter.getAnnotation(Param.class);
            if (!Objects.nonNull(param)) continue;
            params.put(param.value(), args[index]);
        }
        return params;
    }
}

