/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentQuery;

class ArtemisDocumentQuery
implements DocumentQuery {
    private final List<Sort> sorts;
    private final long limit;
    private final long skip;
    private final DocumentCondition condition;
    private final String documentCollection;

    ArtemisDocumentQuery(List<Sort> sorts, long limit, long skip, DocumentCondition condition, String documentCollection) {
        this.sorts = sorts;
        this.limit = limit;
        this.skip = skip;
        this.condition = condition;
        this.documentCollection = documentCollection;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getSkip() {
        return this.skip;
    }

    public String getDocumentCollection() {
        return this.documentCollection;
    }

    public Optional<DocumentCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public List<String> getDocuments() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentQuery)) {
            return false;
        }
        DocumentQuery that = (DocumentQuery)o;
        return this.limit == that.getLimit() && this.skip == that.getSkip() && Objects.equals(this.sorts, that.getSorts()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.documentCollection, that.getDocumentCollection());
    }

    public int hashCode() {
        return Objects.hash(this.limit, this.skip, this.documentCollection, this.condition, this.sorts, Collections.emptyList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ArtemisDocumentQuery{");
        sb.append("limit=").append(this.limit);
        sb.append(", skip=").append(this.skip);
        sb.append(", documentCollection='").append(this.documentCollection).append('\'');
        sb.append(", condition=").append(this.condition);
        sb.append(", sorts=").append(this.sorts);
        sb.append(", documents=").append(Collections.emptyList());
        sb.append('}');
        return sb.toString();
    }
}

