/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.DocumentQueryMapperBuilder;
import org.jnosql.artemis.document.query.DefaultDocumentMapperDeleteBuilder;
import org.jnosql.artemis.document.query.DefaultDocumentMapperSelectBuilder;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.artemis.reflection.ClassRepresentations;
import org.jnosql.diana.api.document.query.DocumentDeleteFrom;
import org.jnosql.diana.api.document.query.DocumentFrom;

@ApplicationScoped
class DefaultDocumentQueryMapperBuilder
implements DocumentQueryMapperBuilder {
    @Inject
    private Instance<ClassRepresentations> classRepresentations;
    @Inject
    private Instance<Converters> converters;

    DefaultDocumentQueryMapperBuilder() {
    }

    @Override
    public <T> DocumentFrom selectFrom(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entity is required");
        ClassRepresentation representation = ((ClassRepresentations)this.classRepresentations.get()).get(entityClass);
        return new DefaultDocumentMapperSelectBuilder(representation, (Converters)this.converters.get());
    }

    @Override
    public <T> DocumentDeleteFrom deleteFrom(Class<T> entityClass) {
        Objects.requireNonNull(entityClass, "entity is required");
        ClassRepresentation representation = ((ClassRepresentations)this.classRepresentations.get()).get(entityClass);
        return new DefaultDocumentMapperDeleteBuilder(representation, (Converters)this.converters.get());
    }
}

