/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.query;

import org.jnosql.artemis.Converters;
import org.jnosql.artemis.document.query.DocumentTokenProcessorType;
import org.jnosql.artemis.reflection.ClassRepresentation;
import org.jnosql.diana.api.Condition;
import org.jnosql.diana.api.document.DocumentCondition;

public final class DocumentQueryParserUtil {
    static final String AND = "And";
    static final String OR = "Or";
    static final String EMPTY = "";
    static final String ORDER_BY = "OrderBy";

    private DocumentQueryParserUtil() {
    }

    public static DocumentCondition toCondition(String token, int index, Object[] args, String methodName, ClassRepresentation representation, Converters converters) {
        DocumentTokenProcessorType processor = DocumentTokenProcessorType.of(token);
        return processor.process(token, index, args, methodName, representation, converters);
    }

    static ConditionResult or(Object[] args, int index, String token, String methodName, ClassRepresentation representation, DocumentCondition queryCondition, Converters converters) {
        String field = token.replace(OR, EMPTY);
        DocumentCondition conditionResult = DocumentQueryParserUtil.toCondition(field, index, args, methodName, representation, converters);
        DocumentCondition condition = null;
        condition = queryCondition == null ? conditionResult : queryCondition.or(conditionResult);
        if (Condition.BETWEEN.equals((Object)condition.getCondition())) {
            return new ConditionResult(index + 2, condition);
        }
        return new ConditionResult(++index, condition);
    }

    static ConditionResult and(Object[] args, int index, String token, String methodName, ClassRepresentation representation, DocumentCondition queryCondition, Converters converters) {
        String field = token.replace(AND, EMPTY);
        DocumentCondition conditionResult = DocumentQueryParserUtil.toCondition(field, index, args, methodName, representation, converters);
        DocumentCondition condition = null;
        condition = queryCondition == null ? conditionResult : queryCondition.and(conditionResult);
        if (Condition.BETWEEN.equals((Object)condition.getCondition())) {
            return new ConditionResult(index + 2, condition);
        }
        return new ConditionResult(++index, condition);
    }

    static class ConditionResult {
        private final int index;
        private final DocumentCondition condition;

        public ConditionResult(int index, DocumentCondition condition) {
            this.index = index;
            this.condition = condition;
        }

        public int getIndex() {
            return this.index;
        }

        public DocumentCondition getCondition() {
            return this.condition;
        }
    }
}

