/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.document.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.document.DocumentTemplate;
import org.jnosql.artemis.document.DocumentTemplateProducer;
import org.jnosql.diana.api.document.DocumentCollectionManager;

class DocumentTemplateBean
implements Bean<DocumentTemplate>,
PassivationCapable {
    private final BeanManager beanManager;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public DocumentTemplateBean(BeanManager beanManager, String provider) {
        this.beanManager = beanManager;
        this.types = Collections.singleton(DocumentTemplate.class);
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofDocument((String)provider));
    }

    public Class<?> getBeanClass() {
        return DocumentTemplate.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public DocumentTemplate create(CreationalContext<DocumentTemplate> creationalContext) {
        DocumentTemplateProducer producer = this.getInstance(DocumentTemplateProducer.class);
        DocumentCollectionManager manager = this.getManager();
        return producer.get(manager);
    }

    private DocumentCollectionManager getManager() {
        Bean bean = (Bean)this.beanManager.getBeans(DocumentCollectionManager.class, new Annotation[]{DatabaseQualifier.ofDocument((String)this.provider)}).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (DocumentCollectionManager)this.beanManager.getReference(bean, DocumentCollectionManager.class, ctx);
    }

    private <T> T getInstance(Class<T> clazz) {
        Bean bean = (Bean)this.beanManager.getBeans(clazz, new Annotation[0]).iterator().next();
        CreationalContext ctx = this.beanManager.createCreationalContext((Contextual)bean);
        return (T)this.beanManager.getReference(bean, clazz, ctx);
    }

    public void destroy(DocumentTemplate instance, CreationalContext<DocumentTemplate> creationalContext) {
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public String getName() {
        return null;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public String getId() {
        return DocumentTemplate.class.getName() + DatabaseType.COLUMN + "-" + this.provider;
    }
}

