/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.Condition;
import org.jnosql.diana.api.TypeReference;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;

final class DefaultDocumentCondition
implements DocumentCondition {
    private final Document document;
    private final Condition condition;

    private DefaultDocumentCondition(Document document, Condition condition) {
        this.document = document;
        this.condition = condition;
    }

    public static DefaultDocumentCondition of(Document document, Condition condition) {
        return new DefaultDocumentCondition(Objects.requireNonNull(document, "Document is required"), condition);
    }

    static DocumentCondition between(Document document) {
        Objects.requireNonNull(document, "document is required");
        DefaultDocumentCondition.checkBetweenClause(document.get());
        return new DefaultDocumentCondition(document, Condition.BETWEEN);
    }

    static DocumentCondition in(Document document) {
        Objects.requireNonNull(document, "document is required");
        Object value = document.get();
        DefaultDocumentCondition.checkInClause(value);
        return new DefaultDocumentCondition(document, Condition.IN);
    }

    private static void checkInClause(Object value) {
        if (!Iterable.class.isInstance(value)) {
            throw new IllegalArgumentException("On DocumentCondition#in you must use an iterable instead of class: " + value.getClass().getName());
        }
    }

    private static void checkBetweenClause(Object value) {
        if (Iterable.class.isInstance(value)) {
            long count = (int)StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).count();
            if (count > 2L) {
                throw new IllegalArgumentException("On Documentcondition#between you must use an iterable with two elements");
            }
            if (count != 2L) {
                throw new IllegalArgumentException("On Documentcondition#between you must use an iterable with two elements");
            }
        } else {
            throw new IllegalArgumentException("On Documentcondition#between you must use an iterable with two elements instead of class: " + value.getClass().getName());
        }
    }

    static DefaultDocumentCondition and(DocumentCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Document document = Document.of(Condition.AND.getNameField(), Arrays.asList(conditions));
        return DefaultDocumentCondition.of(document, Condition.AND);
    }

    static DefaultDocumentCondition or(DocumentCondition ... conditions) {
        Objects.requireNonNull(conditions, "condition is required");
        Document document = Document.of(Condition.OR.getNameField(), Arrays.asList(conditions));
        return DefaultDocumentCondition.of(document, Condition.OR);
    }

    @Override
    public Document getDocument() {
        return this.document;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public DocumentCondition and(DocumentCondition condition) {
        Objects.requireNonNull(condition, "Conditions is required");
        if (Condition.AND.equals((Object)this.condition)) {
            Document column = this.getConditions(condition, Condition.AND);
            return new DefaultDocumentCondition(column, Condition.AND);
        }
        return DefaultDocumentCondition.and(this, condition);
    }

    @Override
    public DocumentCondition negate() {
        if (Condition.NOT.equals((Object)this.condition)) {
            return this.document.get(DocumentCondition.class);
        }
        Document document = Document.of(Condition.NOT.getNameField(), this);
        return new DefaultDocumentCondition(document, Condition.NOT);
    }

    @Override
    public DocumentCondition or(DocumentCondition condition) {
        Objects.requireNonNull(condition, "Condition is required");
        if (Condition.OR.equals((Object)this.condition)) {
            Document document = this.getConditions(condition, Condition.OR);
            return new DefaultDocumentCondition(document, Condition.OR);
        }
        return DefaultDocumentCondition.or(this, condition);
    }

    private Document getConditions(DocumentCondition columnCondition, Condition condition) {
        ArrayList<DocumentCondition> conditions = new ArrayList<DocumentCondition>((Collection)this.document.get(new TypeReference<List<DocumentCondition>>(){}));
        conditions.add(columnCondition);
        return Document.of(condition.getNameField(), conditions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !DocumentCondition.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        DocumentCondition that = (DocumentCondition)o;
        return Objects.equals(this.document, that.getDocument()) && this.condition == that.getCondition();
    }

    public int hashCode() {
        return Objects.hash(this.document, this.condition);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDocumentCondition{");
        sb.append("document=").append(this.document);
        sb.append(", condition=").append(this.condition);
        sb.append('}');
        return sb.toString();
    }
}

