/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.DocumentQueryParser;

public interface DocumentCollectionManager
extends AutoCloseable {
    public DocumentEntity insert(DocumentEntity var1);

    public DocumentEntity insert(DocumentEntity var1, Duration var2);

    default public Iterable<DocumentEntity> insert(Iterable<DocumentEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::insert).collect(Collectors.toList());
    }

    default public Iterable<DocumentEntity> insert(Iterable<DocumentEntity> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(d -> this.insert((DocumentEntity)d, ttl)).collect(Collectors.toList());
    }

    public DocumentEntity update(DocumentEntity var1);

    default public Iterable<DocumentEntity> update(Iterable<DocumentEntity> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::update).collect(Collectors.toList());
    }

    public void delete(DocumentDeleteQuery var1);

    public List<DocumentEntity> select(DocumentQuery var1);

    default public List<DocumentEntity> query(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParser parser = DocumentQueryParser.getParser();
        return parser.query(query, this, DocumentObserverParser.EMPTY);
    }

    default public DocumentPreparedStatement prepare(String query) {
        Objects.requireNonNull(query, "query is required");
        DocumentQueryParser parser = DocumentQueryParser.getParser();
        return parser.prepare(query, this, DocumentObserverParser.EMPTY);
    }

    default public Optional<DocumentEntity> singleResult(DocumentQuery query) {
        List<DocumentEntity> entities = this.select(query);
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.of(entities.get(0));
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + query);
    }

    public long count(String var1);

    @Override
    public void close();
}

