/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.DefaultDocumentEntity;
import org.jnosql.diana.api.document.Document;

public interface DocumentEntity
extends Serializable {
    public static DocumentEntity of(String name) {
        Objects.requireNonNull(name, "name is required");
        return new DefaultDocumentEntity(name);
    }

    public static DocumentEntity of(String name, List<Document> documents) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(documents, "documents is required");
        DefaultDocumentEntity entity = new DefaultDocumentEntity(name);
        entity.addAll(documents);
        return entity;
    }

    public String getName();

    public boolean remove(String var1);

    public List<Document> getDocuments();

    public void add(Document var1);

    public void add(String var1, Object var2);

    public void add(String var1, Value var2);

    public void addAll(Iterable<Document> var1);

    public Optional<Document> find(String var1);

    public int size();

    public boolean isEmpty();

    public DocumentEntity copy();

    public void clear();

    public Set<String> getDocumentNames();

    public Collection<Value> getValues();

    public boolean contains(String var1);

    public Map<String, Object> toMap();
}

