/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.List;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.diana.api.document.query.Values;
import org.jnosql.query.Condition;
import org.jnosql.query.ConditionValue;
import org.jnosql.query.QueryException;
import org.jnosql.query.Where;

final class Conditions {
    private Conditions() {
    }

    static DocumentCondition getCondition(Where where, Params params, DocumentObserverParser observer, String entity) {
        Condition condition = where.getCondition();
        return Conditions.getCondition(condition, params, observer, entity);
    }

    static DocumentCondition getCondition(Condition condition, Params parameters, DocumentObserverParser observer, String entity) {
        switch (condition.getOperator()) {
            case EQUALS: {
                return DocumentCondition.eq(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case GREATER_THAN: {
                return DocumentCondition.gt(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case GREATER_EQUALS_THAN: {
                return DocumentCondition.gte(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case LESSER_THAN: {
                return DocumentCondition.lt(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case LESSER_EQUALS_THAN: {
                return DocumentCondition.lte(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case IN: {
                return DocumentCondition.in(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case LIKE: {
                return DocumentCondition.like(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case BETWEEN: {
                return DocumentCondition.between(Document.of(Conditions.getName(condition, observer, entity), Values.get(condition.getValue(), parameters)));
            }
            case NOT: {
                return Conditions.getCondition((Condition)((List)((ConditionValue)ConditionValue.class.cast(condition.getValue())).get()).get(0), parameters, observer, entity).negate();
            }
            case OR: {
                return DocumentCondition.or((DocumentCondition[])((List)((ConditionValue)ConditionValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(DocumentCondition[]::new));
            }
            case AND: {
                return DocumentCondition.and((DocumentCondition[])((List)((ConditionValue)ConditionValue.class.cast(condition.getValue())).get()).stream().map(v -> Conditions.getCondition(v, parameters, observer, entity)).toArray(DocumentCondition[]::new));
            }
        }
        throw new QueryException("There is not support the type: " + condition.getOperator());
    }

    private static String getName(Condition condition, DocumentObserverParser observer, String entity) {
        return observer.fireField(entity, condition.getName());
    }
}

