/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.query.ReadOnlyDocumentCondition;

class DefaultDocumentDeleteQuery
implements DocumentDeleteQuery {
    private final String documentCollection;
    private final DocumentCondition condition;
    private final List<String> documents;

    DefaultDocumentDeleteQuery(String documentCollection, DocumentCondition condition, List<String> documents) {
        this.documentCollection = documentCollection;
        this.condition = Optional.ofNullable(condition).map(ReadOnlyDocumentCondition::new).orElse(null);
        this.documents = documents;
    }

    @Override
    public String getDocumentCollection() {
        return this.documentCollection;
    }

    @Override
    public Optional<DocumentCondition> getCondition() {
        return Optional.ofNullable(this.condition);
    }

    @Override
    public List<String> getDocuments() {
        return Collections.unmodifiableList(this.documents);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDeleteQuery)) {
            return false;
        }
        DocumentDeleteQuery that = (DocumentDeleteQuery)o;
        return Objects.equals(this.documentCollection, that.getDocumentCollection()) && Objects.equals(this.condition, that.getCondition().orElse(null)) && Objects.equals(this.documents, that.getDocuments());
    }

    public int hashCode() {
        return Objects.hash(this.documentCollection, this.condition, this.documents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultDocumentDeleteQuery{");
        sb.append("documentCollection='").append(this.documentCollection).append('\'');
        sb.append(", condition=").append(this.condition);
        sb.append(", documents=").append(this.documents);
        sb.append('}');
        return sb.toString();
    }
}

