/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.QueryException;

final class DefaultDocumentPreparedStatement
implements DocumentPreparedStatement {
    private final DocumentEntity entity;
    private final DocumentQuery documentQuery;
    private final DocumentDeleteQuery documentDeleteQuery;
    private final PreparedStatementType type;
    private final Params params;
    private final String query;
    private final List<String> paramsLeft;
    private final Duration duration;
    private final DocumentCollectionManager manager;

    private DefaultDocumentPreparedStatement(DocumentEntity entity, DocumentQuery documentQuery, DocumentDeleteQuery documentDeleteQuery, PreparedStatementType type, Params params, String query, List<String> paramsLeft, Duration duration, DocumentCollectionManager manager) {
        this.entity = entity;
        this.documentQuery = documentQuery;
        this.documentDeleteQuery = documentDeleteQuery;
        this.type = type;
        this.params = params;
        this.query = query;
        this.paramsLeft = paramsLeft;
        this.manager = manager;
        this.duration = duration;
    }

    @Override
    public DocumentPreparedStatement bind(String name, Object value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.paramsLeft.remove(name);
        this.params.bind(name, value);
        return this;
    }

    @Override
    public List<DocumentEntity> getResultList() {
        if (!this.paramsLeft.isEmpty()) {
            throw new QueryException("Check all the parameters before execute the query, params left: " + this.paramsLeft);
        }
        switch (this.type) {
            case SELECT: {
                return this.manager.select(this.documentQuery);
            }
            case DELETE: {
                this.manager.delete(this.documentDeleteQuery);
                return Collections.emptyList();
            }
            case UPDATE: {
                return Collections.singletonList(this.manager.update(this.entity));
            }
            case INSERT: {
                if (Objects.isNull(this.duration)) {
                    return Collections.singletonList(this.manager.insert(this.entity));
                }
                return Collections.singletonList(this.manager.insert(this.entity, this.duration));
            }
        }
        throw new UnsupportedOperationException("there is not support to operation type: " + (Object)((Object)this.type));
    }

    @Override
    public Optional<DocumentEntity> getSingleResult() {
        List<DocumentEntity> entities = this.getResultList();
        if (entities.isEmpty()) {
            return Optional.empty();
        }
        if (entities.size() == 1) {
            return Optional.of(entities.get(0));
        }
        throw new NonUniqueResultException("The select returns more than one entity, select: " + this.query);
    }

    public String toString() {
        return this.query;
    }

    static DocumentPreparedStatement select(DocumentQuery documentQuery, Params params, String query, DocumentCollectionManager manager) {
        return new DefaultDocumentPreparedStatement(null, documentQuery, null, PreparedStatementType.SELECT, params, query, params.getParametersNames(), null, manager);
    }

    static DocumentPreparedStatement delete(DocumentDeleteQuery documentDeleteQuery, Params params, String query, DocumentCollectionManager manager) {
        return new DefaultDocumentPreparedStatement(null, null, documentDeleteQuery, PreparedStatementType.DELETE, params, query, params.getParametersNames(), null, manager);
    }

    static DocumentPreparedStatement insert(DocumentEntity entity, Params params, String query, Duration duration, DocumentCollectionManager manager) {
        return new DefaultDocumentPreparedStatement(entity, null, null, PreparedStatementType.INSERT, params, query, params.getParametersNames(), duration, manager);
    }

    static DocumentPreparedStatement update(DocumentEntity entity, Params params, String query, DocumentCollectionManager manager) {
        return new DefaultDocumentPreparedStatement(entity, null, null, PreparedStatementType.UPDATE, params, query, params.getParametersNames(), null, manager);
    }

    static enum PreparedStatementType {
        SELECT,
        DELETE,
        UPDATE,
        INSERT;

    }
}

