/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.api.document.query;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentObserverParser;
import org.jnosql.diana.api.document.DocumentPreparedStatement;
import org.jnosql.diana.api.document.DocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.query.CacheQuery;
import org.jnosql.diana.api.document.query.Conditions;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatement;
import org.jnosql.diana.api.document.query.DefaultDocumentPreparedStatementAsync;
import org.jnosql.diana.api.document.query.DefaultDocumentQuery;
import org.jnosql.diana.api.document.query.Params;
import org.jnosql.query.QueryException;
import org.jnosql.query.SelectQuery;
import org.jnosql.query.SelectQuerySupplier;
import org.jnosql.query.Sort;

final class SelectQueryParser {
    private final SelectQuerySupplier selectQuerySupplier = SelectQuerySupplier.getSupplier();
    private final CacheQuery<DocumentQuery> cache = new CacheQuery<DocumentQuery>(this::getDocumentQuery);

    SelectQueryParser() {
    }

    List<DocumentEntity> query(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        DocumentQuery documentQuery = this.cache.get(query, observer);
        return collectionManager.select(documentQuery);
    }

    void queryAsync(String query, DocumentCollectionManagerAsync collectionManager, Consumer<List<DocumentEntity>> callBack, DocumentObserverParser observer) {
        DocumentQuery documentQuery = this.cache.get(query, observer);
        collectionManager.select(documentQuery, callBack);
    }

    DocumentPreparedStatement prepare(String query, DocumentCollectionManager collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        SelectQuery selectQuery = (SelectQuery)this.selectQuerySupplier.apply((Object)query);
        DocumentQuery documentQuery = this.getDocumentQuery(params, selectQuery, observer);
        return DefaultDocumentPreparedStatement.select(documentQuery, params, query, collectionManager);
    }

    DocumentPreparedStatementAsync prepareAsync(String query, DocumentCollectionManagerAsync collectionManager, DocumentObserverParser observer) {
        Params params = new Params();
        SelectQuery selectQuery = (SelectQuery)this.selectQuerySupplier.apply((Object)query);
        DocumentQuery documentQuery = this.getDocumentQuery(params, selectQuery, observer);
        return DefaultDocumentPreparedStatementAsync.select(documentQuery, params, query, collectionManager);
    }

    private DocumentQuery getDocumentQuery(String query, DocumentObserverParser observer) {
        SelectQuery selectQuery = (SelectQuery)this.selectQuerySupplier.apply((Object)query);
        String collection = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> documents = selectQuery.getFields().stream().map(f -> observer.fireField(collection, (String)f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((org.jnosql.query.Sort)s, observer, collection)).collect(Collectors.toList());
        DocumentCondition condition = null;
        Params params = new Params();
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        if (params.isNotEmpty()) {
            throw new QueryException("To run a query with a parameter use a PrepareStatement instead.");
        }
        return new DefaultDocumentQuery(limit, skip, collection, documents, sorts, condition);
    }

    private DocumentQuery getDocumentQuery(Params params, SelectQuery selectQuery, DocumentObserverParser observer) {
        String collection = observer.fireEntity(selectQuery.getEntity());
        long limit = selectQuery.getLimit();
        long skip = selectQuery.getSkip();
        List<String> documents = selectQuery.getFields().stream().map(f -> observer.fireField(collection, (String)f)).collect(Collectors.toList());
        List<Sort> sorts = selectQuery.getOrderBy().stream().map(s -> this.toSort((org.jnosql.query.Sort)s, observer, collection)).collect(Collectors.toList());
        DocumentCondition condition = null;
        if (selectQuery.getWhere().isPresent()) {
            condition = selectQuery.getWhere().map(c -> Conditions.getCondition(c, params, observer, collection)).get();
        }
        return new DefaultDocumentQuery(limit, skip, collection, documents, sorts, condition);
    }

    private Sort toSort(org.jnosql.query.Sort sort, DocumentObserverParser observer, String entity) {
        return Sort.of((String)observer.fireField(entity, sort.getName()), (Sort.SortType)(sort.getType().equals((Object)Sort.SortType.ASC) ? Sort.SortType.ASC : Sort.SortType.DESC));
    }
}

