/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.mongodb.document;

import com.mongodb.client.model.Filters;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.jnosql.diana.api.TypeReference;
import org.jnosql.diana.api.TypeSupplier;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentCondition;

final class DocumentQueryConversor {
    private DocumentQueryConversor() {
    }

    public static Bson convert(DocumentCondition condition) {
        Document document = condition.getDocument();
        Object value = document.get();
        switch (condition.getCondition()) {
            case EQUALS: {
                return Filters.eq((String)document.getName(), (Object)value);
            }
            case GREATER_THAN: {
                return Filters.gt((String)document.getName(), (Object)value);
            }
            case GREATER_EQUALS_THAN: {
                return Filters.gte((String)document.getName(), (Object)value);
            }
            case LESSER_THAN: {
                return Filters.lt((String)document.getName(), (Object)value);
            }
            case LESSER_EQUALS_THAN: {
                return Filters.lte((String)document.getName(), (Object)value);
            }
            case IN: {
                List inList = (List)document.get((TypeSupplier)new TypeReference<List<Object>>(){});
                return Filters.in((String)document.getName(), (Object[])inList.toArray());
            }
            case NOT: {
                return Filters.not((Bson)DocumentQueryConversor.convert((DocumentCondition)document.get(DocumentCondition.class)));
            }
            case LIKE: {
                return Filters.regex((String)document.getName(), (String)value.toString());
            }
            case AND: {
                List andList = (List)condition.getDocument().getValue().get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){});
                return Filters.and((Iterable)andList.stream().map(DocumentQueryConversor::convert).collect(Collectors.toList()));
            }
            case OR: {
                List orList = (List)condition.getDocument().getValue().get((TypeSupplier)new TypeReference<List<DocumentCondition>>(){});
                return Filters.or((Iterable)orList.stream().map(DocumentQueryConversor::convert).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("The condition " + condition.getCondition() + " is not supported from mongoDB diana driver");
    }
}

