/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.mongodb.document;

import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCollectionManager;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.Documents;
import org.jnosql.diana.mongodb.document.DocumentQueryConversor;
import org.jnosql.diana.mongodb.document.MongoDBUtils;

public class MongoDBDocumentCollectionManager
implements DocumentCollectionManager {
    private static final BsonDocument EMPTY = new BsonDocument();
    private final MongoDatabase mongoDatabase;

    MongoDBDocumentCollectionManager(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    public DocumentEntity insert(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        String collectionName = entity.getName();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Document document = MongoDBUtils.getDocument(entity);
        collection.insertOne((Object)document);
        boolean hasNotId = entity.getDocuments().stream().map(org.jnosql.diana.api.document.Document::getName).noneMatch(k -> k.equals("_id"));
        if (hasNotId) {
            entity.add(Documents.of((String)"_id", (Object)document.get((Object)"_id")));
        }
        return entity;
    }

    public DocumentEntity insert(DocumentEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("MongoDB does not support save with TTL");
    }

    public DocumentEntity update(DocumentEntity entity) {
        Objects.requireNonNull(entity, "entity is required");
        DocumentEntity copy = entity.copy();
        String collectionName = entity.getName();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Document id = copy.find("_id").map(d -> new Document(d.getName(), d.getValue().get())).orElseThrow(() -> new UnsupportedOperationException("To update this DocumentEntity the field `id` is required"));
        copy.remove("_id");
        collection.findOneAndReplace((Bson)id, (Object)MongoDBUtils.getDocument(entity));
        return entity;
    }

    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        String collectionName = query.getDocumentCollection();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Bson mongoDBQuery = DocumentQueryConversor.convert((DocumentCondition)query.getCondition().orElseThrow(() -> new IllegalArgumentException("condition is required")));
        DeleteResult deleteResult = collection.deleteMany(mongoDBQuery);
    }

    public List<DocumentEntity> select(DocumentQuery query) {
        Objects.requireNonNull(query, "query is required");
        String collectionName = query.getDocumentCollection();
        MongoCollection collection = this.mongoDatabase.getCollection(collectionName);
        Bson mongoDBQuery = query.getCondition().map(DocumentQueryConversor::convert).orElse((Bson)EMPTY);
        FindIterable documents = collection.find(mongoDBQuery);
        if (query.getSkip() > 0L) {
            documents.skip((int)query.getSkip());
        }
        if (query.getLimit() > 0L) {
            documents.limit((int)query.getLimit());
        }
        query.getSorts().stream().map(this::getSort).forEach(arg_0 -> ((FindIterable)documents).sort(arg_0));
        return StreamSupport.stream(documents.spliterator(), false).map(MongoDBUtils::of).map(ds -> DocumentEntity.of((String)collectionName, (List)ds)).collect(Collectors.toList());
    }

    public long count(String documentCollection) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        MongoCollection collection = this.mongoDatabase.getCollection(documentCollection);
        return collection.count();
    }

    private Bson getSort(Sort sort) {
        boolean isAscending = Sort.SortType.ASC.equals((Object)sort.getType());
        return isAscending ? Sorts.ascending((String[])new String[]{sort.getName()}) : Sorts.descending((String[])new String[]{sort.getName()});
    }

    public void close() {
    }
}

