/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.mongodb.document;

import com.mongodb.Block;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.result.DeleteResult;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jnosql.diana.api.ExecuteAsyncQueryException;
import org.jnosql.diana.api.Sort;
import org.jnosql.diana.api.document.DocumentCollectionManagerAsync;
import org.jnosql.diana.api.document.DocumentCondition;
import org.jnosql.diana.api.document.DocumentDeleteQuery;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.api.document.DocumentQuery;
import org.jnosql.diana.api.document.Documents;
import org.jnosql.diana.mongodb.document.DocumentQueryConversor;
import org.jnosql.diana.mongodb.document.MongoDBUtils;

public class MongoDBDocumentCollectionManagerAsync
implements DocumentCollectionManagerAsync {
    private static final BsonDocument EMPTY = new BsonDocument();
    private final MongoDatabase asyncMongoDatabase;

    MongoDBDocumentCollectionManagerAsync(MongoDatabase asyncMongoDatabase) {
        this.asyncMongoDatabase = asyncMongoDatabase;
    }

    public void insert(DocumentEntity entity) throws ExecuteAsyncQueryException, UnsupportedOperationException {
        Objects.requireNonNull(entity, "entity is required");
        this.insert(entity, (DocumentEntity v) -> {});
    }

    public void insert(DocumentEntity entity, Duration ttl) {
        throw new UnsupportedOperationException("MongoDB does not support saveAsync with TTL");
    }

    public void insert(DocumentEntity entity, Consumer<DocumentEntity> callBack) throws ExecuteAsyncQueryException, UnsupportedOperationException {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(callBack, "callBack is required");
        this.insert(entity, (SingleResultCallback<Void>)((SingleResultCallback)(aVoid, throwable) -> callBack.accept(entity)));
    }

    public void insert(DocumentEntity entity, Duration ttl, Consumer<DocumentEntity> callBack) {
        throw new UnsupportedOperationException("MongoDB does not support saveAsync with TTL");
    }

    public void update(DocumentEntity entity) throws ExecuteAsyncQueryException, UnsupportedOperationException {
        Objects.requireNonNull(entity, "entity is required");
        this.update(entity, (SingleResultCallback<Document>)((SingleResultCallback)(d, throwable) -> {}));
    }

    public void update(DocumentEntity entity, Consumer<DocumentEntity> callBack) throws ExecuteAsyncQueryException, UnsupportedOperationException {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(callBack, "callBack is required");
        this.update(entity, (SingleResultCallback<Document>)((SingleResultCallback)(d, throwable) -> callBack.accept(DocumentEntity.of((String)entity.getName(), (List)Documents.of((Map)d)))));
    }

    public void delete(DocumentDeleteQuery query) {
        Objects.requireNonNull(query, "query is required");
        this.delete(query, (SingleResultCallback<DeleteResult>)((SingleResultCallback)(deleteResult, throwable) -> {}));
    }

    public void delete(DocumentDeleteQuery query, Consumer<Void> callBack) throws ExecuteAsyncQueryException, UnsupportedOperationException {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        this.delete(query, (SingleResultCallback<DeleteResult>)((SingleResultCallback)(deleteResult, throwable) -> callBack.accept(null)));
    }

    public void select(DocumentQuery query, Consumer<List<DocumentEntity>> callBack) throws ExecuteAsyncQueryException, UnsupportedOperationException {
        Objects.requireNonNull(query, "query is required");
        Objects.requireNonNull(callBack, "callBack is required");
        String collectionName = query.getDocumentCollection();
        MongoCollection collection = this.asyncMongoDatabase.getCollection(collectionName);
        Bson mongoDBQuery = query.getCondition().map(DocumentQueryConversor::convert).orElse((Bson)EMPTY);
        CopyOnWriteArrayList entities = new CopyOnWriteArrayList();
        FindIterable result = collection.find(mongoDBQuery);
        if (query.getSkip() > 0L) {
            result.skip((int)query.getSkip());
        }
        if (query.getLimit() > 0L) {
            result.limit((int)query.getLimit());
        }
        query.getSorts().stream().map(this::getSort).forEach(arg_0 -> ((FindIterable)result).sort(arg_0));
        Block documentBlock = d -> entities.add(this.createEntity(collectionName, (Document)d));
        SingleResultCallback voidSingleResultCallback = (v, e) -> callBack.accept(entities);
        result.forEach(documentBlock, voidSingleResultCallback);
    }

    public void count(String documentCollection, Consumer<Long> callback) {
        Objects.requireNonNull(documentCollection, "documentCollection is required");
        Objects.requireNonNull(callback, "callback is required");
        MongoCollection collection = this.asyncMongoDatabase.getCollection(documentCollection);
        collection.count((l, e) -> callback.accept((Long)l));
    }

    private DocumentEntity createEntity(String collectionName, Document document) {
        return DocumentEntity.of((String)collectionName, MongoDBUtils.of(document));
    }

    private void insert(DocumentEntity entity, SingleResultCallback<Void> callBack) {
        String collectionName = entity.getName();
        MongoCollection collectionAsync = this.asyncMongoDatabase.getCollection(collectionName);
        Document document = MongoDBUtils.getDocument(entity);
        collectionAsync.insertOne((Object)document, callBack);
    }

    private void update(DocumentEntity entity, SingleResultCallback<Document> callBack) {
        String collectionName = entity.getName();
        MongoCollection asyncCollection = this.asyncMongoDatabase.getCollection(collectionName);
        Document id = entity.find("_id").map(d -> new Document(d.getName(), d.getValue().get())).orElseThrow(() -> new UnsupportedOperationException("To update this DocumentEntity the field `_id` is required"));
        asyncCollection.findOneAndReplace((Bson)id, (Object)MongoDBUtils.getDocument(entity), callBack);
    }

    private void delete(DocumentDeleteQuery query, SingleResultCallback<DeleteResult> callBack) {
        String collectionName = query.getDocumentCollection();
        MongoCollection asyncCollection = this.asyncMongoDatabase.getCollection(collectionName);
        Bson mongoDBQuery = DocumentQueryConversor.convert((DocumentCondition)query.getCondition().orElseThrow(() -> new IllegalArgumentException("condition is required")));
        asyncCollection.deleteMany(mongoDBQuery, callBack);
    }

    public void close() {
    }

    private Bson getSort(Sort sort) {
        boolean isAscending = Sort.SortType.ASC.equals((Object)sort.getType());
        return isAscending ? Sorts.ascending((String[])new String[]{sort.getName()}) : Sorts.descending((String[])new String[]{sort.getName()});
    }
}

