/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.mongodb.document;

import com.mongodb.ServerAddress;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jnosql.diana.api.Settings;
import org.jnosql.diana.api.document.DocumentConfiguration;
import org.jnosql.diana.api.document.DocumentConfigurationAsync;
import org.jnosql.diana.driver.ConfigurationReader;
import org.jnosql.diana.mongodb.document.HostPortConfiguration;
import org.jnosql.diana.mongodb.document.MongoDBDocumentCollectionManagerAsyncFactory;
import org.jnosql.diana.mongodb.document.MongoDBDocumentCollectionManagerFactory;

public class MongoDBDocumentConfiguration
implements DocumentConfiguration<MongoDBDocumentCollectionManagerFactory>,
DocumentConfigurationAsync<MongoDBDocumentCollectionManagerAsyncFactory> {
    private static final String FILE_CONFIGURATION = "diana-mongodb.properties";
    static final int DEFAULT_PORT = 27017;

    public MongoDBDocumentCollectionManagerFactory get(Map<String, String> configurations) throws NullPointerException {
        Objects.requireNonNull(configurations, "configurations is required");
        List servers = configurations.keySet().stream().filter(s -> s.startsWith("mongodb-server-host-")).map(configurations::get).map(HostPortConfiguration::new).map(HostPortConfiguration::toServerAddress).collect(Collectors.toList());
        if (servers.isEmpty()) {
            return new MongoDBDocumentCollectionManagerFactory(new com.mongodb.MongoClient());
        }
        return new MongoDBDocumentCollectionManagerFactory(new com.mongodb.MongoClient(servers));
    }

    public MongoDBDocumentCollectionManagerFactory get(com.mongodb.MongoClient mongoClient) throws NullPointerException {
        Objects.requireNonNull(mongoClient, "mongo client is required");
        return new MongoDBDocumentCollectionManagerFactory(mongoClient);
    }

    private MongoClient getAsyncMongoClient(List<ServerAddress> servers) {
        ClusterSettings clusterSettings = ClusterSettings.builder().hosts(servers).build();
        MongoClientSettings settings = MongoClientSettings.builder().clusterSettings(clusterSettings).build();
        return MongoClients.create((MongoClientSettings)settings);
    }

    public MongoDBDocumentCollectionManagerFactory get() {
        Map configuration = ConfigurationReader.from((String)FILE_CONFIGURATION);
        return this.get(configuration);
    }

    public MongoDBDocumentCollectionManagerFactory get(Settings settings) throws NullPointerException {
        Objects.requireNonNull(settings, "settings is required");
        HashMap<String, String> configurations = new HashMap<String, String>();
        settings.forEach((key, value) -> configurations.put((String)key, value.toString()));
        return this.get(configurations);
    }

    public MongoDBDocumentCollectionManagerAsyncFactory getAsync() {
        Map configurations = ConfigurationReader.from((String)FILE_CONFIGURATION);
        return this.getAsync(configurations);
    }

    public MongoDBDocumentCollectionManagerAsyncFactory getAsync(Settings settings) throws NullPointerException {
        Objects.requireNonNull(settings, "settings is required");
        HashMap<String, String> configurations = new HashMap<String, String>();
        settings.forEach((key, value) -> configurations.put((String)key, value.toString()));
        return this.getAsync(configurations);
    }

    public MongoDBDocumentCollectionManagerAsyncFactory getAsync(MongoClient mongoClient) throws NullPointerException {
        Objects.requireNonNull(mongoClient, "mongo client is required");
        return new MongoDBDocumentCollectionManagerAsyncFactory(mongoClient);
    }

    private MongoDBDocumentCollectionManagerAsyncFactory getAsync(Map<String, String> configurations) {
        List<ServerAddress> servers = configurations.keySet().stream().filter(s -> s.startsWith("mongodb-server-host-")).map(configurations::get).map(HostPortConfiguration::new).map(HostPortConfiguration::toServerAddress).collect(Collectors.toList());
        if (servers.isEmpty()) {
            return new MongoDBDocumentCollectionManagerAsyncFactory(MongoClients.create());
        }
        return new MongoDBDocumentCollectionManagerAsyncFactory(this.getAsyncMongoClient(servers));
    }
}

