/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.diana.mongodb.document;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.document.Document;
import org.jnosql.diana.api.document.DocumentEntity;
import org.jnosql.diana.driver.ValueUtil;

final class MongoDBUtils {
    static final String ID_FIELD = "_id";
    private static final Function<Object, String> KEY_DOCUMENT = d -> MongoDBUtils.cast(d).getName();
    private static final Function<Object, Object> VALUE_DOCUMENT = d -> ValueUtil.convert((Value)MongoDBUtils.cast(d).getValue());
    private static final Function<Map.Entry<?, ?>, Document> ENTRY_DOCUMENT = entry -> Document.of((String)entry.getKey().toString(), entry.getValue());

    private MongoDBUtils() {
    }

    static org.bson.Document getDocument(DocumentEntity entity) {
        org.bson.Document document = new org.bson.Document();
        entity.getDocuments().stream().forEach(d -> document.append(d.getName(), MongoDBUtils.convert(d.getValue())));
        return document;
    }

    private static Object convert(Value value) {
        Object val = ValueUtil.convert((Value)value);
        if (val instanceof Document) {
            Document subDocument = (Document)val;
            Object converted = MongoDBUtils.convert(subDocument.getValue());
            return new org.bson.Document(subDocument.getName(), converted);
        }
        if (MongoDBUtils.isSudDocument(val)) {
            return MongoDBUtils.getMap(val);
        }
        if (MongoDBUtils.isSudDocumentList(val)) {
            return StreamSupport.stream(((Iterable)Iterable.class.cast(val)).spliterator(), false).map(MongoDBUtils::getMap).collect(Collectors.toList());
        }
        return val;
    }

    public static List<Document> of(Map<String, ?> values) {
        Predicate<String> isNotNull = s -> values.get(s) != null;
        Function<String, Document> documentMap = key -> {
            Object value = values.get(key);
            if (value instanceof org.bson.Document) {
                return Document.of((String)key, MongoDBUtils.of((Map)org.bson.Document.class.cast(value)));
            }
            if (MongoDBUtils.isDocumentIterable(value)) {
                ArrayList documents = new ArrayList();
                for (Object object : (Iterable)Iterable.class.cast(value)) {
                    Map map = (Map)Map.class.cast(object);
                    documents.add(map.entrySet().stream().map(ENTRY_DOCUMENT).collect(Collectors.toList()));
                }
                return Document.of((String)key, documents);
            }
            return Document.of((String)key, (Value)Value.of(value));
        };
        return values.keySet().stream().filter(isNotNull).map(documentMap).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isDocumentIterable(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(org.bson.Document.class::isInstance)) return false;
        return true;
    }

    private static Object getMap(Object val) {
        return StreamSupport.stream(((Iterable)Iterable.class.cast(val)).spliterator(), false).collect(Collectors.toMap(KEY_DOCUMENT, VALUE_DOCUMENT));
    }

    private static Document cast(Object document) {
        return (Document)Document.class.cast(document);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isSudDocument(Object value) {
        if (!(value instanceof Iterable)) return false;
        if (!StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(Document.class::isInstance)) return false;
        return true;
    }

    private static boolean isSudDocumentList(Object value) {
        return value instanceof Iterable && StreamSupport.stream(((Iterable)Iterable.class.cast(value)).spliterator(), false).allMatch(d -> d instanceof Iterable && MongoDBUtils.isSudDocument(d));
    }
}

