/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jnosql.aphrodite.antlr.AbstractSupplier;
import org.jnosql.aphrodite.antlr.DefaultArrayValue;
import org.jnosql.aphrodite.antlr.DefaultCondition;
import org.jnosql.aphrodite.antlr.DefaultConditionValue;
import org.jnosql.aphrodite.antlr.DefaultStringValue;
import org.jnosql.aphrodite.antlr.DefaultWhere;
import org.jnosql.aphrodite.antlr.QueryParser;
import org.jnosql.aphrodite.antlr.ValueConverter;
import org.jnosql.query.Condition;
import org.jnosql.query.ConditionValue;
import org.jnosql.query.Operator;
import org.jnosql.query.StringValue;
import org.jnosql.query.Value;
import org.jnosql.query.Where;

abstract class AbstractWhereSupplier
extends AbstractSupplier {
    protected Where where;
    protected Condition condition;
    protected boolean and = true;

    AbstractWhereSupplier() {
    }

    @Override
    protected void runQuery(String query) {
        super.runQuery(query);
        if (Objects.nonNull(this.condition)) {
            this.where = new DefaultWhere(this.condition);
        }
    }

    @Override
    public void exitEq(QueryParser.EqContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultCondition(name, Operator.EQUALS, value), hasNot);
    }

    @Override
    public void exitLt(QueryParser.LtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultCondition(name, Operator.LESSER_THAN, value), hasNot);
    }

    @Override
    public void exitLte(QueryParser.LteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultCondition(name, Operator.LESSER_EQUALS_THAN, value), hasNot);
    }

    @Override
    public void exitGt(QueryParser.GtContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultCondition(name, Operator.GREATER_THAN, value), hasNot);
    }

    @Override
    public void exitGte(QueryParser.GteContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value<?> value = ValueConverter.get(ctx.value());
        this.checkCondition(new DefaultCondition(name, Operator.GREATER_EQUALS_THAN, value), hasNot);
    }

    @Override
    public void exitIn(QueryParser.InContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value[] values = (Value[])ctx.value().stream().map(ValueConverter::get).toArray(Value[]::new);
        DefaultArrayValue value = DefaultArrayValue.of(values);
        this.checkCondition(new DefaultCondition(name, Operator.IN, (Value<?>)value), hasNot);
    }

    @Override
    public void exitLike(QueryParser.LikeContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        StringValue value = DefaultStringValue.of(ctx.string());
        this.checkCondition(new DefaultCondition(name, Operator.LIKE, (Value<?>)value), hasNot);
    }

    @Override
    public void exitBetween(QueryParser.BetweenContext ctx) {
        boolean hasNot = Objects.nonNull((Object)ctx.not());
        String name = ctx.name().getText();
        Value[] values = (Value[])ctx.value().stream().map(ValueConverter::get).toArray(Value[]::new);
        this.checkCondition(new DefaultCondition(name, Operator.BETWEEN, (Value<?>)DefaultArrayValue.of(values)), hasNot);
    }

    @Override
    public void exitAnd(QueryParser.AndContext ctx) {
        this.and = true;
    }

    @Override
    public void exitOr(QueryParser.OrContext ctx) {
        this.and = false;
    }

    private void checkCondition(Condition condition, boolean hasNot) {
        Condition newCondition = this.checkNotCondition(condition, hasNot);
        if (Objects.isNull(this.condition)) {
            this.condition = newCondition;
            return;
        }
        if (this.and) {
            this.appendCondition(Operator.AND, newCondition);
        } else {
            this.appendCondition(Operator.OR, newCondition);
        }
    }

    private void appendCondition(Operator operator, Condition newCondition) {
        if (operator.equals((Object)this.condition.getOperator())) {
            ConditionValue conditionValue = (ConditionValue)ConditionValue.class.cast(this.condition.getValue());
            ArrayList<Condition> conditions = new ArrayList<Condition>((Collection)conditionValue.get());
            conditions.add(newCondition);
            this.condition = new DefaultCondition("_" + operator.name(), operator, (Value<?>)DefaultConditionValue.of(conditions));
        } else if (this.isNotAppendable()) {
            List<Condition> conditions = Arrays.asList(this.condition, newCondition);
            this.condition = new DefaultCondition("_" + operator.name(), operator, (Value<?>)DefaultConditionValue.of(conditions));
        } else {
            List conditions = (List)((ConditionValue)ConditionValue.class.cast(this.condition.getValue())).get();
            Condition lastCondition = (Condition)conditions.get(conditions.size() - 1);
            if (this.isAppendable(lastCondition) && operator.equals((Object)lastCondition.getOperator())) {
                ArrayList<Condition> lastConditions = new ArrayList<Condition>((Collection)((ConditionValue)ConditionValue.class.cast(lastCondition.getValue())).get());
                lastConditions.add(newCondition);
                DefaultCondition newAppendable = new DefaultCondition("_" + operator.name(), operator, (Value<?>)DefaultConditionValue.of(lastConditions));
                ArrayList<Condition> newConditions = new ArrayList<Condition>(conditions.subList(0, conditions.size() - 1));
                newConditions.add(newAppendable);
                this.condition = new DefaultCondition(this.condition.getName(), this.condition.getOperator(), (Value<?>)DefaultConditionValue.of(newConditions));
            } else {
                DefaultCondition newAppendable = new DefaultCondition("_" + operator.name(), operator, (Value<?>)DefaultConditionValue.of(Collections.singletonList(newCondition)));
                ArrayList<Condition> newConditions = new ArrayList<Condition>(conditions);
                newConditions.add(newAppendable);
                this.condition = new DefaultCondition(this.condition.getName(), this.condition.getOperator(), (Value<?>)DefaultConditionValue.of(newConditions));
            }
        }
    }

    private boolean isAppendable(Condition condition) {
        return Operator.AND.equals((Object)condition.getOperator()) || Operator.OR.equals((Object)condition.getOperator());
    }

    private boolean isNotAppendable() {
        return !this.isAppendable(this.condition);
    }

    private Condition checkNotCondition(Condition condition, boolean hasNot) {
        if (hasNot) {
            ConditionValue conditions = DefaultConditionValue.of(Collections.singletonList(condition));
            return new DefaultCondition("_NOT", Operator.NOT, (Value<?>)conditions);
        }
        return condition;
    }
}

