/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jnosql.aphrodite.antlr.AbstractWhereSupplier;
import org.jnosql.aphrodite.antlr.DefaultSelectQuery;
import org.jnosql.aphrodite.antlr.DefaultSort;
import org.jnosql.aphrodite.antlr.QueryParser;
import org.jnosql.query.SelectQuery;
import org.jnosql.query.SelectQuerySupplier;
import org.jnosql.query.Sort;

public final class AntlrSelectQuerySupplier
extends AbstractWhereSupplier
implements SelectQuerySupplier {
    private String entity;
    private List<String> fields = Collections.emptyList();
    private List<Sort> sorts = Collections.emptyList();
    private long skip;
    private long limit;

    @Override
    public void exitFields(QueryParser.FieldsContext ctx) {
        this.fields = ctx.name().stream().map(RuleContext::getText).collect(Collectors.toList());
    }

    @Override
    public void exitSkip(QueryParser.SkipContext ctx) {
        this.skip = Long.valueOf(ctx.INT().getText());
    }

    @Override
    public void exitLimit(QueryParser.LimitContext ctx) {
        this.limit = Long.valueOf(ctx.INT().getText());
    }

    @Override
    public void exitEntity(QueryParser.EntityContext ctx) {
        this.entity = ctx.getText();
    }

    @Override
    public void enterOrder(QueryParser.OrderContext ctx) {
        this.sorts = ctx.orderName().stream().map(DefaultSort::of).collect(Collectors.toList());
    }

    public SelectQuery apply(String query) {
        this.runQuery(query);
        return new DefaultSelectQuery(this.entity, this.fields, this.sorts, this.skip, this.limit, this.where);
    }

    @Override
    Function<QueryParser, ParseTree> getParserTree() {
        return QueryParser::select;
    }
}

