/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jnosql.aphrodite.antlr.AbstractSupplier;
import org.jnosql.aphrodite.antlr.DefaultCondition;
import org.jnosql.aphrodite.antlr.DefaultUpdateQuery;
import org.jnosql.aphrodite.antlr.QueryParser;
import org.jnosql.aphrodite.antlr.ValueConverter;
import org.jnosql.query.Condition;
import org.jnosql.query.Operator;
import org.jnosql.query.UpdateQuery;
import org.jnosql.query.UpdateQuerySupplier;
import org.jnosql.query.Value;

public final class AntlrUpdateQuerySupplier
extends AbstractSupplier
implements UpdateQuerySupplier {
    private String entity;
    private List<Condition> conditions = Collections.emptyList();

    @Override
    Function<QueryParser, ParseTree> getParserTree() {
        return QueryParser::update;
    }

    @Override
    public void exitEntity(QueryParser.EntityContext ctx) {
        this.entity = ctx.getText();
    }

    @Override
    public void exitChanges(QueryParser.ChangesContext ctx) {
        this.conditions = ctx.change().stream().map(this::getCondition).collect(Collectors.toList());
    }

    private Condition getCondition(QueryParser.ChangeContext changeContext) {
        String name = changeContext.name().getText();
        Value<?> value = ValueConverter.get(changeContext.value());
        return new DefaultCondition(name, Operator.EQUALS, value);
    }

    public UpdateQuery apply(String query) {
        this.runQuery(query);
        return new DefaultUpdateQuery(this.entity, this.conditions);
    }
}

