/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.aphrodite.antlr.cache;

import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

class TTLCache<K, V>
implements Map<K, V>,
Runnable {
    private static final int DEFAULT_TIME = 5;
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.MINUTES;
    private static final ScheduledExecutorService SCHEDULED_THREAD_POOL = Executors.newScheduledThreadPool(1);
    private final Map<K, V> store = new ConcurrentHashMap();
    private final Map<K, Long> timestamps = new ConcurrentHashMap<K, Long>();
    private final Map<K, WeakReference<K>> mutex = Collections.synchronizedMap(new WeakHashMap());
    private final long ttl;
    private final Function<K, V> supplier;

    TTLCache(long value, TimeUnit unit, Function<K, V> supplier) {
        this.ttl = unit.toNanos(value);
        this.supplier = supplier;
        SCHEDULED_THREAD_POOL.schedule(this, value * 2L, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        V value = this.store.get(key);
        if (Objects.isNull(value)) {
            Object synchronizedKey;
            Object t = synchronizedKey = this.mutex.computeIfAbsent(key, a -> new WeakReference<Object>(key)).get();
            synchronized (t) {
                value = this.supplier.apply(synchronizedKey);
                this.put(synchronizedKey, value);
            }
        }
        this.timestamps.put(key, System.nanoTime());
        return value;
    }

    @Override
    public V put(K key, V value) {
        this.timestamps.put(key, System.nanoTime());
        return this.store.put(key, value);
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        boolean containsKey = this.store.containsKey(key);
        return containsKey ? !this.checkExpired(key) : containsKey;
    }

    @Override
    public boolean containsValue(Object value) {
        return this.store.containsValue(value);
    }

    @Override
    public V remove(Object key) {
        this.timestamps.remove(key);
        return this.store.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Objects.requireNonNull(map, "map is required");
        map.entrySet().forEach(this::put);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        TTLCache tTLCache = this;
        synchronized (tTLCache) {
            this.timestamps.clear();
            this.store.clear();
        }
    }

    @Override
    public Set<K> keySet() {
        return Collections.unmodifiableSet(this.store.keySet());
    }

    @Override
    public Collection<V> values() {
        return Collections.unmodifiableCollection(this.store.values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return Collections.unmodifiableSet(this.store.entrySet());
    }

    @Override
    public void run() {
        if (!this.isEmpty()) {
            this.clearExpired();
        }
    }

    private void clearExpired() {
        this.store.keySet().forEach(this::checkExpired);
    }

    private void put(Map.Entry<? extends K, ? extends V> entry) {
        this.put(entry.getKey(), entry.getValue());
    }

    private boolean checkExpired(Object key) {
        if (this.isObsolete(key)) {
            this.remove(key);
            return true;
        }
        return false;
    }

    private boolean isObsolete(Object key) {
        return System.nanoTime() - this.timestamps.get(key) > this.ttl;
    }

    static <K, V> Map<K, V> of(Function<K, V> supplier) {
        return TTLCache.of(5L, DEFAULT_UNIT, supplier);
    }

    static <K, V> Map<K, V> of(long value, TimeUnit timeUnit, Function<K, V> supplier) {
        Objects.requireNonNull(timeUnit, "timeUnit is required");
        Objects.requireNonNull(supplier, "supplier is required");
        if (value <= 0L) {
            throw new IllegalArgumentException("The value to TTL must be greater than zero");
        }
        return new TTLCache<K, V>(value, timeUnit, supplier);
    }
}

