/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.query;

import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.query.SelectQuerySupplier;

final class SelectQuerySupplierServiceLoader {
    private static final List<SelectQuerySupplier> LOADERS;
    static final Optional<SelectQuerySupplier> INSTANCE;
    private static final String MESSAGE = "Could not found an implementation of SelectQuerySupplier in service loader.";

    private SelectQuerySupplierServiceLoader() {
    }

    static SelectQuerySupplier getInstance() {
        return INSTANCE.orElseThrow(() -> new IllegalStateException(MESSAGE));
    }

    static {
        ServiceLoader<SelectQuerySupplier> serviceLoader = ServiceLoader.load(SelectQuerySupplier.class);
        LOADERS = StreamSupport.stream(serviceLoader.spliterator(), false).collect(Collectors.toList());
        INSTANCE = LOADERS.stream().findFirst();
    }
}

