/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.spring.aot;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jobrunr.dashboard.ui.model.problems.Problem;
import org.jobrunr.jobs.annotations.Recurring;
import org.jobrunr.jobs.lambdas.JobRequestHandler;
import org.jobrunr.server.configuration.BackgroundJobServerThreadType;
import org.jobrunr.spring.autoconfigure.JobRunrProperties;
import org.jobrunr.storage.InMemoryStorageProvider;
import org.jobrunr.storage.StorageProvider;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigration;
import org.jobrunr.storage.nosql.common.migrations.NoSqlMigrationProvider;
import org.jobrunr.storage.nosql.mongo.MongoDBStorageProvider;
import org.jobrunr.storage.nosql.mongo.migrations.MongoMigration;
import org.jobrunr.storage.sql.SqlStorageProvider;
import org.jobrunr.utils.CollectionUtils;
import org.jobrunr.utils.GraalVMUtils;
import org.jobrunr.utils.StringUtils;
import org.jobrunr.utils.VersionNumber;
import org.jobrunr.utils.reflection.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class JobRunrBeanFactoryInitializationAotProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobRunrBeanFactoryInitializationAotProcessor.class);
    private static final MemberCategory[] allMemberCategories = MemberCategory.values();

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        boolean hasJobSchedulerOrDashboardEnabled = this.hasJobSchedulerOrDashboardEnabled(beanFactory);
        Set<String> recurringJobClassNames = JobRunrBeanFactoryInitializationAotProcessor.findAllRecurringJobClassNames(beanFactory);
        Set<String> jobRequestHandlerClassNames = JobRunrBeanFactoryInitializationAotProcessor.findAllJobRequestHandlerClassNames(beanFactory);
        if (hasJobSchedulerOrDashboardEnabled || CollectionUtils.isNotNullOrEmpty(recurringJobClassNames) || CollectionUtils.isNotNullOrEmpty(jobRequestHandlerClassNames)) {
            return (ctx, code) -> {
                RuntimeHints hints = ctx.getRuntimeHints();
                JobRunrBeanFactoryInitializationAotProcessor.registerAllJobRunrClasses(hints);
                JobRunrBeanFactoryInitializationAotProcessor.registerAllRecurringJobs(hints, recurringJobClassNames);
                JobRunrBeanFactoryInitializationAotProcessor.registerAllJobRequestHandlers(hints, jobRequestHandlerClassNames);
            };
        }
        return null;
    }

    private boolean hasJobSchedulerOrDashboardEnabled(ConfigurableListableBeanFactory beanFactory) {
        try {
            JobRunrProperties bean = (JobRunrProperties)beanFactory.getBean(JobRunrProperties.class);
            return bean.getJobScheduler().isEnabled() || bean.getDashboard().isEnabled();
        }
        catch (BeansException e) {
            return false;
        }
    }

    private static Set<String> findAllRecurringJobClassNames(ConfigurableListableBeanFactory beanFactory) {
        String[] beanDefinitionNames = beanFactory.getBeanDefinitionNames();
        return Arrays.stream(beanDefinitionNames).map(bn -> JobRunrBeanFactoryInitializationAotProcessor.mapBeanNameToClassName(beanFactory, bn)).filter(JobRunrBeanFactoryInitializationAotProcessor::isARecurringJob).collect(Collectors.toSet());
    }

    private static Set<String> findAllJobRequestHandlerClassNames(ConfigurableListableBeanFactory beanFactory) {
        return Arrays.stream(beanFactory.getBeanNamesForType(JobRequestHandler.class)).map(bn -> JobRunrBeanFactoryInitializationAotProcessor.mapBeanNameToClassName(beanFactory, bn)).collect(Collectors.toSet());
    }

    private static void registerAllRecurringJobs(RuntimeHints hints, Set<String> recurringJobClassNames) {
        for (String clazz : recurringJobClassNames) {
            Class clazzObject = ReflectionUtils.toClass((String)clazz);
            hints.reflection().registerType(clazzObject, allMemberCategories);
        }
    }

    private static void registerAllJobRequestHandlers(RuntimeHints hints, Set<String> jobRequestHandlerClassNames) {
        for (String clazz : jobRequestHandlerClassNames) {
            Class clazzObject = ReflectionUtils.toClass((String)clazz);
            hints.reflection().registerType(clazzObject, allMemberCategories);
            Method runMethod = Stream.of(clazzObject.getMethods()).filter(m -> m.getName().equals("run")).toList().get(0);
            Class<?> jobRequestType = runMethod.getParameterTypes()[0];
            hints.reflection().registerType(jobRequestType, allMemberCategories);
        }
    }

    private static void registerAllJobRunrClasses(RuntimeHints hints) {
        JobRunrBeanFactoryInitializationAotProcessor.registerRequiredJobRunrClasses(hints);
        JobRunrBeanFactoryInitializationAotProcessor.registerRequiredResources(hints);
        JobRunrBeanFactoryInitializationAotProcessor.registerAllAssignableTypesOf(hints, Problem.class);
        JobRunrBeanFactoryInitializationAotProcessor.registerAllAssignableTypesOf(hints, InMemoryStorageProvider.class);
        JobRunrBeanFactoryInitializationAotProcessor.registerAllAssignableTypesOf(hints, SqlStorageProvider.class);
        JobRunrBeanFactoryInitializationAotProcessor.registerAllAssignableTypesOf(hints, NoSqlMigration.class);
        JobRunrBeanFactoryInitializationAotProcessor.registerAllAssignableTypesOf(hints, NoSqlMigrationProvider.class);
        JobRunrBeanFactoryInitializationAotProcessor.registerNoSqlStorageProvider(hints, MongoDBStorageProvider.class, MongoMigration.class, "org/jobrunr/storage/nosql/mongo/migrations/*");
    }

    private static void registerRequiredJobRunrClasses(RuntimeHints hints) {
        ReflectionHints reflectionHints = hints.reflection();
        GraalVMUtils.JOBRUNR_CLASSES.forEach(clazz -> reflectionHints.registerType(clazz, allMemberCategories));
        if (BackgroundJobServerThreadType.VirtualThreads.isSupported(VersionNumber.JAVA_VERSION)) {
            try {
                hints.reflection().registerType(Thread.class, new MemberCategory[]{MemberCategory.DECLARED_CLASSES, MemberCategory.INVOKE_PUBLIC_METHODS}).registerType(Class.forName("java.lang.Thread$Builder"), allMemberCategories).registerType(Executors.class, allMemberCategories).registerType(ExecutorService.class, allMemberCategories);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Could not register virtual threads");
            }
        }
    }

    private static void registerRequiredResources(RuntimeHints hints) {
        hints.resources().registerPattern("org/jobrunr/configuration/JobRunr.class").registerPattern("org/jobrunr/dashboard/frontend/build/*").registerPattern("org/jobrunr/storage/sql/*").registerPattern("META-INF/MANIFEST.MF");
    }

    private static void registerNoSqlStorageProvider(RuntimeHints runtimeHints, Class<? extends StorageProvider> storageProviderClass, Class<?> migrationProviderClass, String pathToMigrations) {
        boolean isStorageProviderOnClasspath = JobRunrBeanFactoryInitializationAotProcessor.registerHintByClassName(runtimeHints, storageProviderClass.getName());
        if (isStorageProviderOnClasspath) {
            JobRunrBeanFactoryInitializationAotProcessor.registerAllAssignableTypesOf(runtimeHints, migrationProviderClass);
            runtimeHints.resources().registerPattern(pathToMigrations);
        }
    }

    private static void registerAllAssignableTypesOf(RuntimeHints runtimeHints, Class<?> anyClass) {
        Set<String> candidateClassNamesToRegister = JobRunrBeanFactoryInitializationAotProcessor.findAllAssignableClassesOf(anyClass);
        runtimeHints.reflection().registerType(anyClass, allMemberCategories);
        LOGGER.debug("Register JobRunr class for reflection SUCCEEDED: class " + anyClass.getName() + " available for reflection in Spring Boot Native.");
        for (String candidateClassNameToRegister : candidateClassNamesToRegister) {
            JobRunrBeanFactoryInitializationAotProcessor.registerHintByClassName(runtimeHints, candidateClassNameToRegister);
        }
    }

    private static Set<String> findAllAssignableClassesOf(Class<?> anyClass) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(anyClass));
        Set candidateComponents = provider.findCandidateComponents("org.jobrunr");
        return candidateComponents.stream().map(BeanDefinition::getBeanClassName).collect(Collectors.toSet());
    }

    private static boolean isARecurringJob(String className) {
        if (StringUtils.isNullOrEmpty((String)className)) {
            return false;
        }
        if (className.startsWith("java") || className.startsWith("org.springframework") || className.startsWith("org.jobrunr")) {
            return false;
        }
        try {
            Class aClass = ReflectionUtils.loadClass((String)className);
            return ReflectionUtils.findMethod((Class)aClass, method -> method.isAnnotationPresent(Recurring.class)).isPresent();
        }
        catch (ClassNotFoundException shouldNotHappen) {
            throw new IllegalStateException("Spring provided a className which is not on the classpath", shouldNotHappen);
        }
    }

    private static String mapBeanNameToClassName(ConfigurableListableBeanFactory beanFactory, String bn) {
        AnnotatedBeanDefinition annotatedBeanDefinition;
        MethodMetadata factoryMethodMetadata;
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(bn);
        if (beanDefinition instanceof AnnotatedBeanDefinition && (factoryMethodMetadata = (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()) != null) {
            return factoryMethodMetadata.getReturnTypeName();
        }
        return beanDefinition.getBeanClassName();
    }

    private static boolean registerHintByClassName(RuntimeHints runtimeHints, String className) {
        try {
            Class clazz = ReflectionUtils.toClass((String)className);
            runtimeHints.reflection().registerType(clazz, allMemberCategories);
            LOGGER.debug("Register JobRunr class for reflection SUCCEEDED: class " + className + " available for reflection in Spring Boot Native.");
            return true;
        }
        catch (NoClassDefFoundError e) {
            LOGGER.debug("Register JobRunr class for reflection FAILED: Could not load class " + className + " as class dependencies (imports) are not available.");
            return false;
        }
    }
}

