/*
 * Decompiled with CFR 0.152.
 */
package org.jobrunr.spring.autoconfigure;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.jobrunr.jobs.details.CachingJobDetailsGenerator;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;

@ConfigurationProperties(prefix="org.jobrunr")
public class JobRunrProperties {
    private Database database = new Database();
    private Jobs jobs = new Jobs();
    private JobScheduler jobScheduler = new JobScheduler();
    private Dashboard dashboard = new Dashboard();
    private BackgroundJobServer backgroundJobServer = new BackgroundJobServer();
    private Miscellaneous miscellaneous = new Miscellaneous();

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public Jobs getJobs() {
        return this.jobs;
    }

    public void setJobs(Jobs jobs) {
        this.jobs = jobs;
    }

    public JobScheduler getJobScheduler() {
        return this.jobScheduler;
    }

    public void setJobScheduler(JobScheduler jobScheduler) {
        this.jobScheduler = jobScheduler;
    }

    public Dashboard getDashboard() {
        return this.dashboard;
    }

    public void setDashboard(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    public BackgroundJobServer getBackgroundJobServer() {
        return this.backgroundJobServer;
    }

    public void setBackgroundJobServer(BackgroundJobServer backgroundJobServer) {
        this.backgroundJobServer = backgroundJobServer;
    }

    public Miscellaneous getMiscellaneous() {
        return this.miscellaneous;
    }

    public void setMiscellaneous(Miscellaneous miscellaneous) {
        this.miscellaneous = miscellaneous;
    }

    public static class Metrics {
        private boolean enabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    public static class Miscellaneous {
        private boolean allowAnonymousDataUsage = true;

        public boolean isAllowAnonymousDataUsage() {
            return this.allowAnonymousDataUsage;
        }

        public void setAllowAnonymousDataUsage(boolean allowAnonymousDataUsage) {
            this.allowAnonymousDataUsage = allowAnonymousDataUsage;
        }
    }

    public static class Dashboard {
        private boolean enabled = false;
        private int port = 8000;
        private String username = null;
        private String password = null;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }
    }

    public static class BackgroundJobServer {
        private boolean enabled = false;
        private Integer workerCount;
        private Integer pollIntervalInSeconds = 15;
        private Integer scheduledJobsRequestSize = 1000;
        private Integer orphanedJobsRequestSize = 1000;
        private Integer succeededJobsRequestSize = 1000;
        @DurationUnit(value=ChronoUnit.HOURS)
        private Duration deleteSucceededJobsAfter = Duration.ofHours(36L);
        @DurationUnit(value=ChronoUnit.HOURS)
        private Duration permanentlyDeleteDeletedJobsAfter = Duration.ofHours(72L);
        private Metrics metrics = new Metrics();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getWorkerCount() {
            return this.workerCount;
        }

        public void setWorkerCount(Integer workerCount) {
            this.workerCount = workerCount;
        }

        public Integer getPollIntervalInSeconds() {
            return this.pollIntervalInSeconds;
        }

        public void setPollIntervalInSeconds(Integer pollIntervalInSeconds) {
            this.pollIntervalInSeconds = pollIntervalInSeconds;
        }

        public Integer getScheduledJobsRequestSize() {
            return this.scheduledJobsRequestSize;
        }

        public BackgroundJobServer setScheduledJobsRequestSize(Integer scheduledJobsRequestSize) {
            this.scheduledJobsRequestSize = scheduledJobsRequestSize;
            return this;
        }

        public Integer getOrphanedJobsRequestSize() {
            return this.orphanedJobsRequestSize;
        }

        public BackgroundJobServer setOrphanedJobsRequestSize(Integer orphanedJobsRequestSize) {
            this.orphanedJobsRequestSize = orphanedJobsRequestSize;
            return this;
        }

        public Integer getSucceededJobsRequestSize() {
            return this.succeededJobsRequestSize;
        }

        public BackgroundJobServer setSucceededJobsRequestSize(Integer succeededJobsRequestSize) {
            this.succeededJobsRequestSize = succeededJobsRequestSize;
            return this;
        }

        public Duration getDeleteSucceededJobsAfter() {
            return this.deleteSucceededJobsAfter;
        }

        public void setDeleteSucceededJobsAfter(Duration deleteSucceededJobsAfter) {
            this.deleteSucceededJobsAfter = deleteSucceededJobsAfter;
        }

        public Duration getPermanentlyDeleteDeletedJobsAfter() {
            return this.permanentlyDeleteDeletedJobsAfter;
        }

        public void setPermanentlyDeleteDeletedJobsAfter(Duration permanentlyDeleteDeletedJobsAfter) {
            this.permanentlyDeleteDeletedJobsAfter = permanentlyDeleteDeletedJobsAfter;
        }

        public Metrics getMetrics() {
            return this.metrics;
        }

        public void setMetrics(Metrics metrics) {
            this.metrics = metrics;
        }
    }

    public static class JobScheduler {
        private boolean enabled = true;
        private String jobDetailsGenerator = CachingJobDetailsGenerator.class.getName();

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getJobDetailsGenerator() {
            return this.jobDetailsGenerator;
        }

        public void setJobDetailsGenerator(String jobDetailsGenerator) {
            this.jobDetailsGenerator = jobDetailsGenerator;
        }
    }

    public static class Jobs {
        private int defaultNumberOfRetries = 10;
        private int backOffTimeSeed = 3;
        private Metrics metrics = new Metrics();

        public int getDefaultNumberOfRetries() {
            return this.defaultNumberOfRetries;
        }

        public void setDefaultNumberOfRetries(int defaultNumberOfRetries) {
            this.defaultNumberOfRetries = defaultNumberOfRetries;
        }

        public int getRetryBackOffTimeSeed() {
            return this.backOffTimeSeed;
        }

        public void setRetryBackOffTimeSeed(int backOffTimeSeed) {
            this.backOffTimeSeed = backOffTimeSeed;
        }

        public Metrics getMetrics() {
            return this.metrics;
        }

        public void setMetrics(Metrics metrics) {
            this.metrics = metrics;
        }
    }

    public static class Database {
        private boolean skipCreate = false;
        private String databaseName;
        private String tablePrefix;
        private String datasource;
        private String type;

        public void setSkipCreate(boolean skipCreate) {
            this.skipCreate = skipCreate;
        }

        public boolean isSkipCreate() {
            return this.skipCreate;
        }

        public String getTablePrefix() {
            return this.tablePrefix;
        }

        public void setTablePrefix(String tablePrefix) {
            this.tablePrefix = tablePrefix;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public String getDatasource() {
            return this.datasource;
        }

        public void setDatasource(String datasource) {
            this.datasource = datasource;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

