/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.joda.convert.TypedFromStringConverter;

final class MethodFromStringConverter<T>
implements TypedFromStringConverter<T> {
    private final Method fromString;
    private final Class<?> effectiveType;

    MethodFromStringConverter(Class<T> cls, Method fromString, Class<?> effectiveType) {
        if (!Modifier.isStatic(fromString.getModifiers())) {
            throw new IllegalStateException("FromString method must be static: " + String.valueOf(fromString));
        }
        if (fromString.getParameterTypes().length != 1) {
            throw new IllegalStateException("FromString method must have one parameter: " + String.valueOf(fromString));
        }
        Class<?> param = fromString.getParameterTypes()[0];
        if (param != String.class && param != CharSequence.class) {
            throw new IllegalStateException("FromString method must take a String or CharSequence: " + String.valueOf(fromString));
        }
        if (!fromString.getReturnType().isAssignableFrom(cls) && !cls.isAssignableFrom(fromString.getReturnType())) {
            throw new IllegalStateException("FromString method must return specified class or a supertype: " + String.valueOf(fromString));
        }
        this.fromString = fromString;
        this.effectiveType = effectiveType;
    }

    @Override
    public T convertFromString(Class<? extends T> cls, String str) {
        try {
            return cls.cast(this.fromString.invoke(null, str));
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("Method is not accessible: " + String.valueOf(this.fromString));
        }
        catch (InvocationTargetException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    public Class<?> getEffectiveType() {
        return this.effectiveType;
    }
}

