/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.handler;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Executor;
import org.jolokia.server.core.http.BackChannel;

public class HttpExchangeBackChannel
implements BackChannel,
Runnable {
    private HttpExchange exchange;
    private final Executor executor;
    private boolean closed = true;

    public HttpExchangeBackChannel(HttpExchange pExchange, Executor pExecutor) {
        this.exchange = pExchange;
        this.executor = pExecutor;
    }

    @Override
    public synchronized void open(Map<String, ?> pParams) throws IOException {
        if (this.exchange == null) {
            throw new IllegalStateException("Channel has been already used and can't be reused. You need to create a new channel");
        }
        this.setResponseHeaders(pParams);
        this.closed = false;
        this.executor.execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpExchangeBackChannel httpExchangeBackChannel = this;
        synchronized (httpExchangeBackChannel) {
            while (!this.closed) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    @Override
    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            this.notifyAll();
            this.exchange.close();
            this.exchange = null;
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        if (!this.closed) {
            return this.exchange.getResponseBody();
        }
        throw new IOException("Channel is already closed");
    }

    private void setResponseHeaders(Map<String, ?> pParams) throws IOException {
        Headers headers = this.exchange.getResponseHeaders();
        if (pParams.containsKey("backChannel.contentType")) {
            Object ct = (String)pParams.get("backChannel.contentType");
            if (pParams.containsKey("backChannel.encoding")) {
                ct = (String)ct + ";charset=" + pParams.get("backChannel.encoding");
            }
            headers.add("Content-Type", (String)ct);
        }
        this.exchange.sendResponseHeaders(200, 0L);
    }
}

