/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.server.core.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.management.MalformedObjectNameException;
import org.jolokia.server.core.request.JolokiaObjectNameRequest;
import org.jolokia.server.core.request.ProcessingParameters;
import org.jolokia.server.core.request.RequestCreator;
import org.jolokia.server.core.util.EscapeUtil;
import org.jolokia.server.core.util.RequestType;
import org.jolokia.shaded.org.json.simple.JSONObject;

public class JolokiaReadRequest
extends JolokiaObjectNameRequest {
    private List<String> attributeNames;
    private boolean multiAttributeMode = false;

    JolokiaReadRequest(String pObjectName, String pAttribute, List<String> pPathParts, ProcessingParameters pInitParams) throws MalformedObjectNameException {
        super(RequestType.READ, pObjectName, pPathParts, pInitParams, true);
        this.initAttribute(pAttribute);
    }

    JolokiaReadRequest(Map<String, ?> pRequestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
        super(pRequestMap, pParams, true);
        this.initAttribute(pRequestMap.get("attribute"));
    }

    public String getAttributeName() {
        if (this.attributeNames == null) {
            return null;
        }
        if (this.isMultiAttributeMode()) {
            throw new IllegalStateException("Request contains more than one attribute (attrs = " + this.attributeNames + "). Use getAttributeNames() instead.");
        }
        return this.attributeNames.get(0);
    }

    public List<String> getAttributeNames() {
        return this.attributeNames;
    }

    public boolean isMultiAttributeMode() {
        return this.multiAttributeMode;
    }

    public boolean hasAttribute() {
        return this.isMultiAttributeMode() || this.getAttributeName() != null;
    }

    @Override
    public JSONObject toJSON() {
        JSONObject ret = super.toJSON();
        if (this.attributeNames != null && !this.attributeNames.isEmpty()) {
            if (this.attributeNames.size() > 1) {
                ret.put("attribute", this.attributeNames);
            } else {
                ret.put("attribute", this.attributeNames.get(0));
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("JmxReadRequest[");
        this.appendReadParameters(ret);
        String baseInfo = this.getInfo();
        if (baseInfo != null) {
            ret.append(", ").append(baseInfo);
        }
        ret.append("]");
        return ret.toString();
    }

    static RequestCreator<JolokiaReadRequest> newCreator() {
        return new RequestCreator<JolokiaReadRequest>(){

            @Override
            public JolokiaReadRequest create(Stack<String> pStack, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JolokiaReadRequest(pStack.pop(), this.popOrNull(pStack), this.prepareExtraArgs(pStack), pParams);
            }

            @Override
            public JolokiaReadRequest create(Map<String, ?> requestMap, ProcessingParameters pParams) throws MalformedObjectNameException {
                return new JolokiaReadRequest(requestMap, pParams);
            }
        };
    }

    private void appendReadParameters(StringBuffer pRet) {
        if (this.isMultiAttributeMode()) {
            pRet.append("attribute=[");
            for (int i = 0; i < this.attributeNames.size(); ++i) {
                pRet.append(this.attributeNames.get(i));
                if (i >= this.attributeNames.size() - 1) continue;
                pRet.append(",");
            }
            pRet.append("]");
        } else {
            pRet.append("attribute=").append(this.getAttributeName());
        }
    }

    private void initAttribute(Object pAttrval) {
        if (pAttrval instanceof String) {
            this.attributeNames = EscapeUtil.split((String)pAttrval, "\\\\", ",");
            this.multiAttributeMode = this.attributeNames.size() > 1;
        } else if (pAttrval instanceof Collection) {
            Collection attributes = (Collection)pAttrval;
            if (attributes.size() == 1 && attributes.iterator().next() == null) {
                this.attributeNames = null;
                this.multiAttributeMode = false;
            } else {
                this.attributeNames = new ArrayList<String>(attributes);
                this.multiAttributeMode = true;
            }
        } else if (pAttrval == null) {
            this.attributeNames = null;
            this.multiAttributeMode = false;
        } else {
            throw new IllegalArgumentException("Attribute names must be either a String, Collection or null (and not " + pAttrval.getClass() + ")");
        }
    }
}

