/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.list;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.jolokia.service.jmx.handler.list.AttributeDataUpdater;
import org.jolokia.service.jmx.handler.list.ClassNameDataUpdater;
import org.jolokia.service.jmx.handler.list.DataKeys;
import org.jolokia.service.jmx.handler.list.DataUpdater;
import org.jolokia.service.jmx.handler.list.DescriptionDataUpdater;
import org.jolokia.service.jmx.handler.list.NotificationDataUpdater;
import org.jolokia.service.jmx.handler.list.OperationDataUpdater;
import org.jolokia.shaded.org.json.simple.JSONObject;

public class MBeanInfoData {
    private final int maxDepth;
    private final Stack<String> pathStack;
    private final Map infoMap = new JSONObject();
    private static final Map<String, DataUpdater> UPDATERS = new HashMap<String, DataUpdater>();
    private final boolean useCanonicalName;
    private final String pProvider;

    public MBeanInfoData(int pMaxDepth, Stack<String> pPathStack, boolean pUseCanonicalName, String pProvider) {
        this.maxDepth = pMaxDepth;
        this.useCanonicalName = pUseCanonicalName;
        this.pathStack = pPathStack != null ? (Stack)pPathStack.clone() : new Stack();
        this.pProvider = pProvider;
    }

    public boolean handleFirstOrSecondLevel(ObjectName pName) {
        if (this.maxDepth == 1 && this.pathStack.isEmpty()) {
            this.infoMap.put(this.addProviderIfNeeded(pName.getDomain()), 1);
            return true;
        }
        if (this.maxDepth == 2 && this.pathStack.isEmpty()) {
            Map mBeansMap = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
            mBeansMap.put(this.getKeyPropertyString(pName), 1);
            return true;
        }
        return false;
    }

    private String getKeyPropertyString(ObjectName pName) {
        return this.useCanonicalName ? pName.getCanonicalKeyPropertyListString() : pName.getKeyPropertyListString();
    }

    public void addMBeanInfo(MBeanInfo mBeanInfo, ObjectName pName) throws InstanceNotFoundException, IntrospectionException, IOException {
        Map mBeansMap = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
        Map mBeanMap = this.getOrCreateJSONObject(mBeansMap, this.getKeyPropertyString(pName));
        Stack<String> stack = this.truncatePathStack(2);
        if (stack.empty()) {
            this.addFullMBeanInfo(mBeanMap, mBeanInfo);
        } else {
            this.addPartialMBeanInfo(mBeanMap, mBeanInfo, stack);
        }
        if (mBeanMap.isEmpty()) {
            mBeansMap.remove(this.getKeyPropertyString(pName));
            if (mBeansMap.isEmpty()) {
                this.infoMap.remove(this.addProviderIfNeeded(pName.getDomain()));
            }
        }
    }

    private String addProviderIfNeeded(String pDomain) {
        return this.pProvider != null ? this.pProvider + "@" + pDomain : pDomain;
    }

    public void handleException(ObjectName pName, IOException pExp) throws IOException {
        if (!this.pathStack.isEmpty()) {
            throw new IOException("IOException for MBean " + pName + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, IllegalStateException pExp) {
        if (!this.pathStack.isEmpty()) {
            throw new IllegalStateException("IllegalStateException for MBean " + pName + " (" + pExp.getMessage() + ")", pExp);
        }
        this.addException(pName, pExp);
    }

    public void handleException(ObjectName pName, InstanceNotFoundException pExp) throws InstanceNotFoundException {
        if (!this.pathStack.isEmpty()) {
            throw new InstanceNotFoundException("InstanceNotFoundException for MBean " + pName + " (" + pExp.getMessage() + ")");
        }
        this.addException(pName, pExp);
    }

    private void addException(ObjectName pName, Exception pExp) {
        Map mBeansMap = this.getOrCreateJSONObject(this.infoMap, this.addProviderIfNeeded(pName.getDomain()));
        Map mBeanMap = this.getOrCreateJSONObject(mBeansMap, this.getKeyPropertyString(pName));
        mBeanMap.put(DataKeys.ERROR.getKey(), pExp.toString());
    }

    public Object applyPath() {
        Object value = this.navigatePath();
        if (this.maxDepth == 0) {
            return value;
        }
        if (!(value instanceof JSONObject)) {
            return value;
        }
        return this.truncateJSONObject((JSONObject)value, this.maxDepth);
    }

    private void addFullMBeanInfo(Map pMBeanMap, MBeanInfo pMBeanInfo) {
        for (DataUpdater updater : UPDATERS.values()) {
            updater.update(pMBeanMap, pMBeanInfo, null);
        }
    }

    private void addPartialMBeanInfo(Map pMBeanMap, MBeanInfo pMBeanInfo, Stack<String> pPathStack) {
        String what = pPathStack.empty() ? null : pPathStack.pop();
        DataUpdater updater = UPDATERS.get(what);
        if (updater == null) {
            throw new IllegalArgumentException("Illegal path element " + what);
        }
        updater.update(pMBeanMap, pMBeanInfo, pPathStack);
    }

    private Map getOrCreateJSONObject(Map pMap, String pKey) {
        Map nMap = (Map)pMap.get(pKey);
        if (nMap == null) {
            nMap = new JSONObject();
            pMap.put(pKey, nMap);
        }
        return nMap;
    }

    private Object truncateJSONObject(JSONObject pValue, int pMaxDepth) {
        if (pMaxDepth == 0) {
            return 1;
        }
        JSONObject ret = new JSONObject();
        Set entries = pValue.entrySet();
        for (Map.Entry entry : entries) {
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value instanceof JSONObject) {
                ret.put(key, this.truncateJSONObject((JSONObject)value, pMaxDepth - 1));
                continue;
            }
            ret.put(key, value);
        }
        return ret;
    }

    private Stack<String> truncatePathStack(int pLevel) {
        if (this.pathStack.size() < pLevel) {
            return new Stack<String>();
        }
        Stack ret = (Stack)this.pathStack.clone();
        for (int i = 0; i < pLevel; ++i) {
            ret.pop();
        }
        return ret;
    }

    private Object navigatePath() {
        Map innerMap = this.infoMap;
        for (int size = this.pathStack.size(); size > 0; --size) {
            Collection vals = innerMap.values();
            if (vals.isEmpty()) {
                return innerMap;
            }
            if (vals.size() != 1) {
                throw new IllegalStateException("Internal: More than one key found when extracting with path: " + vals);
            }
            Object value = vals.iterator().next();
            if (size == 1) {
                return value;
            }
            if (!(value instanceof JSONObject)) {
                throw new IllegalStateException("Internal: Value within path extraction must be a Map, not " + value.getClass());
            }
            innerMap = (JSONObject)value;
        }
        return innerMap;
    }

    static {
        for (DataUpdater updater : new DataUpdater[]{new DescriptionDataUpdater(), new ClassNameDataUpdater(), new AttributeDataUpdater(), new OperationDataUpdater(), new NotificationDataUpdater()}) {
            UPDATERS.put(updater.getKey(), updater);
        }
    }
}

