/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;
import org.jolokia.shaded.org.json.simple.JSONObject;

public class MapExtractor
implements Extractor {
    private static final int MAX_STRING_LENGTH = 400;

    @Override
    public Class<?> getType() {
        return Map.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathParth;
        Map map = (Map)pValue;
        int length = pConverter.getCollectionLength(map.size());
        String string = pathParth = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathParth != null) {
            return this.extractMapValueWithPath(pConverter, pValue, pPathParts, jsonify, map, pathParth);
        }
        return jsonify ? this.extractMapValues(pConverter, pPathParts, jsonify, map, length) : map;
    }

    private JSONObject extractMapValues(ObjectToJsonConverter pConverter, Stack<String> pPathParts, boolean jsonify, Map<Object, Object> pMap, int pLength) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        int i = 0;
        for (Map.Entry<Object, Object> entry : pMap.entrySet()) {
            Stack paths = (Stack)pPathParts.clone();
            try {
                ret.put(entry.getKey(), pConverter.extractObject(entry.getValue(), paths, jsonify));
                if (++i <= pLength) continue;
                break;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {
            }
        }
        if (ret.isEmpty() && pLength > 0) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractMapValueWithPath(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify, Map<Object, Object> pMap, String pPathParth) throws AttributeNotFoundException {
        for (Map.Entry<Object, Object> entry : pMap.entrySet()) {
            if (!pPathParth.equals(entry.getKey().toString())) continue;
            return pConverter.extractObject(entry.getValue(), pPathParts, jsonify);
        }
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        return faultHandler.handleException(new AttributeNotFoundException("Map key '" + pPathParth + "' is unknown for map " + this.trimString(pValue.toString())));
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pMap, String pKey, Object pValue) throws IllegalAccessException, InvocationTargetException {
        Map map = (Map)pMap;
        Object oldValue = null;
        String oldKey = pKey;
        for (Map.Entry entry : map.entrySet()) {
            if (!pKey.equals(entry.getKey().toString())) continue;
            oldValue = entry.getValue();
            oldKey = entry.getKey();
            break;
        }
        Object value = oldValue != null ? pConverter.deserialize(oldValue.getClass().getName(), pValue) : pValue;
        map.put(oldKey, value);
        return oldValue;
    }

    @Override
    public boolean canSetValue() {
        return true;
    }

    private String trimString(String pString) {
        if (pString.length() > 400) {
            return pString.substring(0, 400) + " ...";
        }
        return pString;
    }
}

