/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.HttpServer;

class CleanupThread
extends Thread {
    private final HttpServer server;
    private final ThreadGroup threadGroup;
    private boolean active = true;
    private static final String[] DAEMON_THREAD_NAMES = new String[]{"WrapperListener_stop_runner", "DestroyJavaVM"};

    CleanupThread(HttpServer pServer, ThreadGroup pThreadGroup) {
        super("Jolokia Agent Cleanup Thread");
        this.server = pServer;
        this.threadGroup = pThreadGroup;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            boolean retry = true;
            while (retry && this.active) {
                Thread[] threads = this.enumerateThreads();
                retry = this.joinThreads(threads);
            }
        }
        finally {
            this.server.stop(0);
        }
    }

    public void stopServer() {
        this.active = false;
        this.interrupt();
    }

    private Thread[] enumerateThreads() {
        boolean fits = false;
        int inc = 50;
        Thread[] threads = null;
        int nrThreads = 0;
        while (!fits) {
            try {
                threads = new Thread[Thread.activeCount() + inc];
                nrThreads = Thread.enumerate(threads);
                fits = true;
            }
            catch (ArrayIndexOutOfBoundsException exp) {
                inc += 50;
            }
        }
        Thread[] ret = new Thread[nrThreads];
        System.arraycopy(threads, 0, ret, 0, nrThreads);
        return ret;
    }

    private boolean joinThreads(Thread[] pThreads) {
        for (Thread t : pThreads) {
            if (this.isDaemonLikeThread(t)) continue;
            try {
                t.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return false;
    }

    private boolean isDaemonLikeThread(Thread pThread) {
        if (pThread.isDaemon() || pThread.getThreadGroup() == null || pThread.getThreadGroup().equals(this.threadGroup)) {
            return true;
        }
        for (String name : DAEMON_THREAD_NAMES) {
            if (!pThread.getName().startsWith(name)) continue;
            return true;
        }
        return false;
    }
}

